/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.NullOp2;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.client.rendering.AddParticlesFromPosAtClient2;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProcessBlockDirectivesEventHandler {
    static Optional<Operator2> optOp = Optional.empty();
    static Supplier<Operator2> splOp = () -> {
        if (optOp.isPresent()) {
            return optOp.get();
        }
        if (ModConfiguration.spawnedBlockParticles == null) {
            return new NullOp2();
        }
        ParticleRenderingInfo particleConfig = ConfigUtils.createInfoFromConfig(ModConfiguration.spawnedBlockParticles);
        AddParticlesFromPosAtClient2 op = new AddParticlesFromPosAtClient2(particleConfig);
        optOp = Optional.of(op);
        return optOp.get();
    };

    @SubscribeEvent
    public static void handleServerTickEvent(TickEvent.ServerTickEvent event) {
        try {
            BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
            if (repository.isEmpty()) {
                return;
            }
            for (int i = 0; i < 3; ++i) {
                ProcessBlockDirectivesEventHandler.processDirective();
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void processDirective() throws Exception {
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        while (!repository.isEmpty()) {
            BlockDirective directive = repository.getNext();
            World world = directive.getWorld();
            BlockState currentState = world.func_180495_p(directive.getBlockPosition());
            if (currentState.equals(directive.getState())) continue;
            BlockUtils.createBlock(directive);
            BlockPos pos = directive.getBlockPosition();
            Ports ports = DefaultPorts.getInstance().setBlockPosition1(pos);
            Operators2.run(ports, splOp.get());
        }
    }
}

