/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.duration;

import bassebombecraft.event.duration.Duration;
import java.util.Optional;
import java.util.function.Consumer;

public class DefaultDuration
implements Duration {
    static final int IS_EXPIRED = 0;
    int duration;
    String id;
    Optional<Consumer<String>> optRemovalCallback;
    Optional<Consumer<String>> optUpdateCallback;

    DefaultDuration(int duration, String id) {
        this.duration = duration;
        this.id = id;
        this.optUpdateCallback = Optional.empty();
        this.optRemovalCallback = Optional.empty();
    }

    DefaultDuration(int duration, String id, Consumer<String> cRemovalCallback) {
        this.duration = duration;
        this.id = id;
        this.optUpdateCallback = Optional.empty();
        this.optRemovalCallback = Optional.of(cRemovalCallback);
    }

    DefaultDuration(int duration, String id, Consumer<String> cUpdateCallback, Consumer<String> cRemovalCallback) {
        this.duration = duration;
        this.id = id;
        this.optUpdateCallback = Optional.of(cUpdateCallback);
        this.optRemovalCallback = Optional.of(cRemovalCallback);
    }

    @Override
    public void update() {
        if (this.isExpired()) {
            return;
        }
        if (this.optUpdateCallback.isPresent()) {
            Consumer<String> cUpdateCallback = this.optUpdateCallback.get();
            cUpdateCallback.accept(this.id);
        }
        if (this.neverExpires()) {
            return;
        }
        --this.duration;
    }

    @Override
    public boolean isExpired() {
        return this.duration == 0;
    }

    @Override
    public boolean neverExpires() {
        return this.duration == -1;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public int get() {
        return this.duration;
    }

    @Override
    public void notifyOfExpiry() {
        if (!this.optRemovalCallback.isPresent()) {
            return;
        }
        Consumer<String> cRemovalCallback = this.optRemovalCallback.get();
        cRemovalCallback.accept(this.id);
    }

    public static Duration getInstance(int duration, String id) {
        return new DefaultDuration(duration, id);
    }

    public static Duration getInstance(int duration, String id, Consumer<String> cRemovalCallback) {
        return new DefaultDuration(duration, id, cRemovalCallback);
    }

    public static Duration getInstance(int duration, String id, Consumer<String> cUpdateCallback, Consumer<String> cRemovalCallback) {
        return new DefaultDuration(duration, id, cUpdateCallback, cRemovalCallback);
    }
}

