/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.target;

import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.player.PlayerUtils;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Stream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;

public class DefaultTargetRepository
implements TargetRepository {
    static final Set<LivingEntity> nullTargetsSet = new HashSet<LivingEntity>();
    Map<PlayerEntity, Targets> targetSets = new ConcurrentHashMap<PlayerEntity, Targets>();
    Map<LivingEntity, Targets> targetMembership = new ConcurrentHashMap<LivingEntity, Targets>();

    @Override
    public void createTargets(PlayerEntity commander) {
        if (commander == null) {
            return;
        }
        if (this.isCommander(commander)) {
            return;
        }
        Targets commandersTargets = new Targets(commander);
        this.targetSets.put(commander, commandersTargets);
    }

    @Override
    public void deleteTargets(PlayerEntity commander) {
        if (commander == null) {
            return;
        }
        if (!this.isCommander(commander)) {
            return;
        }
        this.clear(commander);
        this.targetSets.remove(commander);
    }

    @Override
    public void clear(PlayerEntity commander) {
        if (commander == null) {
            return;
        }
        if (!this.isCommander(commander)) {
            return;
        }
        Targets commandersTargets = this.targetSets.get(commander);
        Set<LivingEntity> targetSet = commandersTargets.targets;
        targetSet.forEach(t -> this.targetMembership.remove(t));
    }

    @Override
    public boolean isCommander(PlayerEntity commander) {
        if (commander == null) {
            return false;
        }
        return this.targetSets.containsKey(commander);
    }

    @Override
    public void add(PlayerEntity commander, LivingEntity entity) {
        if (commander == null) {
            return;
        }
        if (entity == null) {
            return;
        }
        if (!this.isCommander(commander)) {
            this.createTargets(commander);
        }
        Targets commandersTargets = this.targetSets.get(commander);
        this.targetMembership.put(entity, commandersTargets);
        commandersTargets.targets.add(entity);
    }

    @Override
    public void remove(LivingEntity entity) {
        if (entity == null) {
            return;
        }
        if (!this.targetMembership.containsKey(entity)) {
            return;
        }
        Targets commandersTargets = this.targetMembership.get(entity);
        commandersTargets.targets.remove(entity);
        this.targetMembership.remove(entity);
    }

    @Override
    public Stream<LivingEntity> get(PlayerEntity commander) {
        if (commander == null) {
            return nullTargetsSet.stream();
        }
        if (!this.isCommander(commander)) {
            return nullTargetsSet.stream();
        }
        Targets commandersTargets = this.targetSets.get(commander);
        return commandersTargets.targets.stream();
    }

    @Override
    public Optional<LivingEntity> getFirst(PlayerEntity commander) {
        if (commander == null) {
            return Optional.empty();
        }
        if (!this.isCommander(commander)) {
            return Optional.empty();
        }
        if (EntityUtils.hasAliveTarget((LivingEntity)commander)) {
            return EntityUtils.getNullableTarget((LivingEntity)commander);
        }
        Targets commandersTargets = this.targetSets.get(commander);
        if (commandersTargets.targets.isEmpty()) {
            return Optional.empty();
        }
        LivingEntity target = commandersTargets.targets.iterator().next();
        return Optional.ofNullable(target);
    }

    @Override
    public Optional<LivingEntity> getFirst(LivingEntity commander) {
        if (!PlayerUtils.isTypePlayerEntity((Entity)commander)) {
            return Optional.empty();
        }
        PlayerEntity commanderAsPlayer = (PlayerEntity)commander;
        return this.getFirst(commanderAsPlayer);
    }

    @Override
    public int size(PlayerEntity commander) {
        if (commander == null) {
            return 0;
        }
        if (!this.isCommander(commander)) {
            return 0;
        }
        Targets commandersTargets = this.targetSets.get(commander);
        return commandersTargets.targets.size();
    }

    public static TargetRepository getInstance() {
        return new DefaultTargetRepository();
    }

    class Targets {
        PlayerEntity commander;
        Set<LivingEntity> targets = Collections.synchronizedSet(new HashSet());

        public Targets(PlayerEntity commander) {
            this.commander = commander;
        }

        public boolean equals(Object obj) {
            Targets team = (Targets)obj;
            return this.commander.equals((Object)team.commander);
        }

        public String toString() {
            return "Targets for: " + this.commander.func_146103_bH().getName();
        }
    }
}

