/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.entity.target;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.entity.target.TargetRepository;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.world.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class TargetEventHandler {
    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        if (WorldUtils.isLogicalClient(event.getEntity())) {
            return;
        }
        TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
        LivingEntity entity = event.getEntityLiving();
        repository.remove(entity);
        if (PlayerUtils.isTypePlayerEntity((Entity)event.getEntityLiving())) {
            PlayerEntity player = (PlayerEntity)event.getEntityLiving();
            if (!repository.isCommander(player)) {
                return;
            }
            repository.clear(player);
        }
    }

    @SubscribeEvent
    public static void handleAttackEntityEvent(AttackEntityEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            PlayerEntity player = event.getPlayer();
            Entity target = event.getTarget();
            if (!EntityUtils.isTypeLivingEntity(target)) {
                return;
            }
            LivingEntity targetAsLivingEntity = (LivingEntity)target;
            TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
            repository.add(player, targetAsLivingEntity);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedInEvent(PlayerEvent.PlayerLoggedInEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
            repository.createTargets(event.getPlayer());
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @SubscribeEvent
    public static void handlePlayerLoggedOutEvent(PlayerEvent.PlayerLoggedOutEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            TargetRepository repository = BassebombeCraft.getProxy().getServerTargetRepository();
            repository.deleteTargets(event.getPlayer());
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

