/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.frequency;

import bassebombecraft.event.frequency.FrequencyRepository;
import java.util.concurrent.ConcurrentHashMap;

public class DefaultFrequencyRepository
implements FrequencyRepository {
    int counter = 0;
    ConcurrentHashMap<String, FrequencyState> frequencies = new ConcurrentHashMap();

    @Override
    public void update() {
        ++this.counter;
    }

    @Override
    public void add(String id, int frequency) {
        if (this.frequencies.containsKey(id)) {
            return;
        }
        FrequencyState freq = new FrequencyState();
        freq.id = id;
        freq.frequency = frequency;
        this.frequencies.put(id, freq);
    }

    @Override
    public boolean isActive(String id) {
        if (!this.frequencies.containsKey(id)) {
            return false;
        }
        FrequencyState freq = this.frequencies.get(id);
        int value = this.counter % freq.frequency;
        return value == 0;
    }

    @Override
    public boolean isActive(int frequency) {
        int value = this.counter % frequency;
        return value == 0;
    }

    public static FrequencyRepository getInstance() {
        return new DefaultFrequencyRepository();
    }

    class FrequencyState {
        int frequency;
        String id;

        FrequencyState() {
        }
    }
}

