/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.particle;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistries;

public class DefaultParticleRenderingInfo
implements ParticleRenderingInfo {
    BasicParticleType type;
    String unresolvedType;
    int number;
    int duration;
    float rgbRed;
    float rgbBlue;
    float rgbGreen;
    double speed;

    DefaultParticleRenderingInfo(BasicParticleType type, int number, int duration, float rgbRed, float rgbGreen, float rgbBlue, double speed) {
        this.type = type;
        this.unresolvedType = type.getRegistryName().toString();
        this.number = number;
        this.duration = duration;
        this.rgbRed = rgbRed;
        this.rgbGreen = rgbGreen;
        this.rgbBlue = rgbBlue;
        this.speed = speed;
    }

    DefaultParticleRenderingInfo(String type, int number, int duration, float rgbRed, float rgbGreen, float rgbBlue, double speed) {
        this.unresolvedType = type;
        this.type = null;
        this.number = number;
        this.duration = duration;
        this.rgbRed = rgbRed;
        this.rgbGreen = rgbGreen;
        this.rgbBlue = rgbBlue;
        this.speed = speed;
    }

    @Override
    public BasicParticleType getParticleType() {
        if (this.type != null) {
            return this.type;
        }
        ResourceLocation key = new ResourceLocation(this.unresolvedType.toLowerCase());
        ParticleType resolved = (ParticleType)ForgeRegistries.PARTICLE_TYPES.getValue(key);
        if (resolved != null) {
            this.type = (BasicParticleType)resolved;
            return this.type;
        }
        String msg = "Failed to initialize particle from configuration value : " + key;
        BassebombeCraft.getBassebombeCraft().reportAndLogError(msg);
        return ParticleTypes.field_197633_z;
    }

    @Override
    public int getNumber() {
        return this.number;
    }

    @Override
    public int getDuration() {
        return this.duration;
    }

    @Override
    public float getRedColorComponent() {
        return this.rgbRed;
    }

    @Override
    public float getGreenColorComponent() {
        return this.rgbGreen;
    }

    @Override
    public float getBlueColorComponent() {
        return this.rgbBlue;
    }

    @Override
    public double getSpeed() {
        return this.speed;
    }

    public static ParticleRenderingInfo getInstance(BasicParticleType type, int number, int duration, float rgbRed, float rgbGreen, float rgbBlue, double speed) {
        return new DefaultParticleRenderingInfo(type, number, duration, rgbRed, rgbGreen, rgbBlue, speed);
    }

    public static ParticleRenderingInfo getUnresolvedInstance(String type, int number, int duration, float rgbRed, float rgbGreen, float rgbBlue, double speed) {
        return new DefaultParticleRenderingInfo(type, number, duration, rgbRed, rgbGreen, rgbBlue, speed);
    }
}

