/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.event.projectile;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.LazyInitOp2;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.Sequence2;
import bassebombecraft.operator.conditional.IsLivingEntityHitInRaytraceResult2;
import bassebombecraft.operator.entity.Explode2;
import bassebombecraft.operator.entity.Respawn2;
import bassebombecraft.operator.entity.ShootMeteor2;
import bassebombecraft.operator.entity.potion.effect.AddEffect2;
import bassebombecraft.operator.entity.raytraceresult.Bounce2;
import bassebombecraft.operator.entity.raytraceresult.Charm2;
import bassebombecraft.operator.entity.raytraceresult.Dig2;
import bassebombecraft.operator.entity.raytraceresult.DigMobHole2;
import bassebombecraft.operator.entity.raytraceresult.EmitHorizontalForce2;
import bassebombecraft.operator.entity.raytraceresult.EmitVerticalForce2;
import bassebombecraft.operator.entity.raytraceresult.ExplodeOnImpact2;
import bassebombecraft.operator.entity.raytraceresult.SpawnAnvil2;
import bassebombecraft.operator.entity.raytraceresult.SpawnCobweb2;
import bassebombecraft.operator.entity.raytraceresult.SpawnDecoy2;
import bassebombecraft.operator.entity.raytraceresult.SpawnIceBlock2;
import bassebombecraft.operator.entity.raytraceresult.SpawnLavaBlock2;
import bassebombecraft.operator.entity.raytraceresult.SpawnLightning2;
import bassebombecraft.operator.entity.raytraceresult.SpawnSquid2;
import bassebombecraft.operator.entity.raytraceresult.TeleportInvoker2;
import bassebombecraft.operator.entity.raytraceresult.TeleportMob2;
import bassebombecraft.operator.projectile.modifier.tag.ReceiveAggro2;
import bassebombecraft.operator.sound.PlaySound2;
import bassebombecraft.potion.effect.RegisteredEffects;
import bassebombecraft.world.WorldUtils;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.event.entity.ProjectileImpactEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber
public class ProjectileModifierEventHandler {
    public static final String NAME = ProjectileModifierEventHandler.class.getSimpleName();
    static Supplier<Operator2> splTeleportInvokerOp = () -> new Sequence2(new TeleportInvoker2(), new PlaySound2(ModConfiguration.teleportInvokerSound.getSplSound()));
    static final Operator2 teleportInvokerOp = LazyInitOp2.of(splTeleportInvokerOp);
    static final Operator2 TELEPORT_MOB_OPERATOR = new TeleportMob2();
    static final Operator2 CHARM_OPERATOR = new Charm2();
    static Supplier<Operator2> splMeteorOp = () -> {
        Function<Ports, LivingEntity> fnGetInvoker = DefaultPorts.getFnGetLivingEntity1();
        Function<Ports, LivingEntity> fnGetTarget = p -> {
            RayTraceResult result = p.getRayTraceResult1();
            EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
            return (LivingEntity)entityResult.func_216348_a();
        };
        return new Sequence2(new IsLivingEntityHitInRaytraceResult2(), new ShootMeteor2(fnGetInvoker, fnGetTarget));
    };
    static final Operator2 METEOR_OPERATOR = splMeteorOp.get();
    static Supplier<Operator2> splDecoyOp = () -> {
        Function<Ports, LivingEntity> fnGetTarget = DefaultPorts.getFnGetLivingEntity2();
        BiConsumer<Ports, EffectInstance> bcSetEffectInstance = DefaultPorts.getBcSetEffectInstance1();
        return new Sequence2(new SpawnDecoy2(), new AddEffect2(fnGetTarget, bcSetEffectInstance, (Effect)RegisteredEffects.RECEIVE_AGGRO_EFFECT.get(), (Integer)ModConfiguration.receiveAggroEffectDuration.get(), (Integer)ModConfiguration.receiveAggroEffectAmplifier.get()));
    };
    static final Operator2 decoyOp = LazyInitOp2.of(splDecoyOp);
    static final Operator2 EXPLODE_WHEN_KILLED_OPERATOR = new Explode2();
    static final Operator2 RESPAWN_WHEN_KILLED_OPERATOR = new Respawn2();
    static final Operator2 EXPLODE_ON_IMPACT_OPERATOR = new ExplodeOnImpact2();
    static final Operator2 DIGMOBHOLE_OPERATOR = new DigMobHole2();
    static final Operator2 DIG_OPERATOR = new Dig2();
    static final Operator2 COBWEB_OPERATOR = new SpawnCobweb2();
    static final Operator2 ICEBLOCK_OPERATOR = new SpawnIceBlock2();
    static final Operator2 LAVABLOCK_OPERATOR = new SpawnLavaBlock2();
    static final Operator2 ANVIL_OPERATOR = new SpawnAnvil2();
    static Supplier<Operator2> splReceiveAggroOp = () -> {
        Function<Ports, LivingEntity> fnGetTarget = p -> {
            RayTraceResult result = p.getRayTraceResult1();
            EntityRayTraceResult entityResult = (EntityRayTraceResult)result;
            return (LivingEntity)entityResult.func_216348_a();
        };
        BiConsumer<Ports, EffectInstance> bcSetEffectInstance = DefaultPorts.getBcSetEffectInstance1();
        return new Sequence2(new IsLivingEntityHitInRaytraceResult2(), new AddEffect2(fnGetTarget, bcSetEffectInstance, (Effect)RegisteredEffects.RECEIVE_AGGRO_EFFECT.get(), (Integer)ModConfiguration.receiveAggroEffectDuration.get(), (Integer)ModConfiguration.receiveAggroEffectAmplifier.get()));
    };
    static final Operator2 receiveAggroOp = LazyInitOp2.of(splReceiveAggroOp);
    static final Operator2 BOUNCE_ON_IMPACT_OPERATOR = new Bounce2();
    static final Operator2 HORIZONTAL_FORCE_OPERATOR = new EmitHorizontalForce2();
    static final Operator2 VERTICAL_FORCE_OPERATOR = new EmitVerticalForce2();
    static final Operator2 LIGHTNING_OPERATOR = new SpawnLightning2();
    static final Operator2 SQUID_OPERATOR = new SpawnSquid2();

    @SubscribeEvent
    public static void handleProjectileImpactEvent(ProjectileImpactEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            Entity projectile = event.getEntity();
            Set tags = projectile.func_184216_O();
            if (tags.isEmpty()) {
                return;
            }
            if (tags.contains(TeleportInvoker2.NAME)) {
                ProjectileModifierEventHandler.teleportInvoker(event);
            }
            if (tags.contains(TeleportMob2.NAME)) {
                ProjectileModifierEventHandler.teleportMob(event);
            }
            if (tags.contains(Charm2.NAME)) {
                ProjectileModifierEventHandler.charmMob(event);
            }
            if (tags.contains(ShootMeteor2.NAME)) {
                ProjectileModifierEventHandler.shootMeteor(event);
            }
            if (tags.contains(SpawnDecoy2.NAME)) {
                ProjectileModifierEventHandler.spawnDecoy(event);
            }
            if (tags.contains(DigMobHole2.NAME)) {
                ProjectileModifierEventHandler.digMobHole(event);
            }
            if (tags.contains(Dig2.NAME)) {
                ProjectileModifierEventHandler.drill(event);
            }
            if (tags.contains(SpawnCobweb2.NAME)) {
                ProjectileModifierEventHandler.spawnCobweb(event);
            }
            if (tags.contains(SpawnIceBlock2.NAME)) {
                ProjectileModifierEventHandler.spawnIceBlock(event);
            }
            if (tags.contains(SpawnLavaBlock2.NAME)) {
                ProjectileModifierEventHandler.spawnLavaBlock(event);
            }
            if (tags.contains(SpawnAnvil2.NAME)) {
                ProjectileModifierEventHandler.spawnAnvil(event);
            }
            if (tags.contains(EmitHorizontalForce2.NAME)) {
                ProjectileModifierEventHandler.emitHorizontalForce(event);
            }
            if (tags.contains(EmitVerticalForce2.NAME)) {
                ProjectileModifierEventHandler.emitVerticalForce(event);
            }
            if (tags.contains(Explode2.NAME)) {
                ProjectileModifierEventHandler.explodeOnImpact(event);
            }
            if (tags.contains(ReceiveAggro2.NAME)) {
                ProjectileModifierEventHandler.receiveAggro(event);
            }
            if (tags.contains(Bounce2.NAME)) {
                ProjectileModifierEventHandler.bounceOnImpact(event);
            }
            if (tags.contains(SpawnLightning2.NAME)) {
                ProjectileModifierEventHandler.spawnLightning(event);
            }
            if (tags.contains(SpawnSquid2.NAME)) {
                ProjectileModifierEventHandler.spawnSquid(event);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @SubscribeEvent
    public static void handleLivingDeathEvent(LivingDeathEvent event) {
        try {
            if (WorldUtils.isLogicalClient(event.getEntity())) {
                return;
            }
            DamageSource source = event.getSource();
            Entity immediateSource = source.func_76364_f();
            if (immediateSource == null) {
                return;
            }
            Set tags = immediateSource.func_184216_O();
            if (tags.isEmpty()) {
                return;
            }
            if (tags.contains(Explode2.NAME)) {
                ProjectileModifierEventHandler.explodeMobWhenKilled(event);
            }
            if (tags.contains(Respawn2.NAME)) {
                ProjectileModifierEventHandler.respawnWhenKilled(event);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    static void teleportInvoker(ProjectileImpactEvent event) {
        Optional<LivingEntity> optShooter = ProjectileUtils.resolveShooter(event);
        if (!optShooter.isPresent()) {
            return;
        }
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setLivingEntity1(optShooter.get());
        Operators2.run(ports, teleportInvokerOp);
    }

    static void teleportMob(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        Operators2.run(ports, TELEPORT_MOB_OPERATOR);
    }

    static void charmMob(ProjectileImpactEvent event) {
        Optional<LivingEntity> optShooter = ProjectileUtils.resolveShooter(event);
        if (!optShooter.isPresent()) {
            return;
        }
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setLivingEntity1(optShooter.get());
        Operators2.run(ports, CHARM_OPERATOR);
    }

    static void shootMeteor(ProjectileImpactEvent event) {
        Optional<LivingEntity> optShooter = ProjectileUtils.resolveShooter(event);
        if (!optShooter.isPresent()) {
            return;
        }
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setLivingEntity1(optShooter.get());
        Operators2.run(ports, METEOR_OPERATOR);
    }

    static void spawnDecoy(ProjectileImpactEvent event) {
        Optional<LivingEntity> optShooter = ProjectileUtils.resolveShooter(event);
        if (!optShooter.isPresent()) {
            return;
        }
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setLivingEntity1(optShooter.get());
        Operators2.run(ports, decoyOp);
    }

    static void digMobHole(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, DIGMOBHOLE_OPERATOR);
    }

    static void drill(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, DIG_OPERATOR);
        event.setCanceled(true);
    }

    static void spawnCobweb(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, COBWEB_OPERATOR);
    }

    static void spawnIceBlock(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, ICEBLOCK_OPERATOR);
    }

    static void spawnLavaBlock(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, LAVABLOCK_OPERATOR);
    }

    static void spawnAnvil(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, ANVIL_OPERATOR);
    }

    static void emitHorizontalForce(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setEntity1(event.getEntity());
        Operators2.run(ports, HORIZONTAL_FORCE_OPERATOR);
    }

    static void emitVerticalForce(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        Operators2.run(ports, VERTICAL_FORCE_OPERATOR);
    }

    static void explodeOnImpact(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, EXPLODE_ON_IMPACT_OPERATOR);
    }

    static void receiveAggro(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        Operators2.run(ports, receiveAggroOp);
    }

    static void bounceOnImpact(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setEntity1(event.getEntity());
        Operators2.run(ports, BOUNCE_ON_IMPACT_OPERATOR);
        event.setCanceled(true);
    }

    static void spawnLightning(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, LIGHTNING_OPERATOR);
    }

    static void spawnSquid(ProjectileImpactEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setRayTraceResult1(event.getRayTraceResult());
        ports.setWorld(event.getEntity().func_130014_f_());
        Operators2.run(ports, SQUID_OPERATOR);
    }

    static void explodeMobWhenKilled(LivingDeathEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setEntity1(event.getEntity());
        Operators2.run(ports, EXPLODE_WHEN_KILLED_OPERATOR);
    }

    static void respawnWhenKilled(LivingDeathEvent event) {
        Ports ports = DefaultPorts.getInstance();
        ports.setLivingEntity1(event.getEntityLiving());
        Operators2.run(ports, RESPAWN_WHEN_KILLED_OPERATOR);
    }
}

