/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.inventory.container;

import bassebombecraft.inventory.container.CompositeMagicItemItemStackHandler;
import bassebombecraft.inventory.container.RegisteredContainers;
import bassebombecraft.world.WorldUtils;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.ContainerType;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.SlotItemHandler;

public class CompositeMagicItemContainer
extends Container {
    public static final String NAME = CompositeMagicItemContainer.class.getSimpleName();
    static final int SLOT_X_SPACING = 18;
    static final int SLOT_Y_SPACING = 18;
    static final int HOTBAR_SLOT_COUNT = 9;
    static final int HOTBAR_XPOS = 8;
    static final int HOTBAR_YPOS = 142;
    static final int PLAYER_INVENTORY_XPOS = 8;
    static final int PLAYER_INVENTORY_YPOS = 84;
    static final int PLAYER_INVENTORY_ROW_COUNT = 3;
    static final int PLAYER_INVENTORY_COLUMN_COUNT = 9;
    static final int COMPOSITE_SLOT_COUNT = 6;
    static final int COMPOSITE_XPOS = 17;
    static final int COMPOSITE_YPOS = 26;
    ItemStack itemStackBeingHeld;
    PlayerInventory inventory;
    CompositeMagicItemItemStackHandler compositeItemInventory;

    public CompositeMagicItemContainer(int id, PlayerInventory inventory, PacketBuffer extraData) {
        this(id, inventory, new CompositeMagicItemItemStackHandler(6), ItemStack.field_190927_a);
    }

    public CompositeMagicItemContainer(int id, PlayerInventory inventory, CompositeMagicItemItemStackHandler compositeItemInventory, ItemStack compositeItem) {
        super((ContainerType)RegisteredContainers.COMPOSITE_ITEM_COMTAINER.get(), id);
        this.itemStackBeingHeld = compositeItem;
        this.inventory = inventory;
        this.compositeItemInventory = compositeItemInventory;
        this.addCompositeSlots();
        this.addHotBarSlots();
        this.addPlayerInventorySlots();
    }

    void addCompositeSlots() {
        for (int x = 0; x < 6; ++x) {
            int index = x;
            this.func_75146_a((Slot)new SlotItemHandler((IItemHandler)this.compositeItemInventory, index, 17 + 18 * x, 26));
        }
    }

    void addHotBarSlots() {
        for (int x = 0; x < 9; ++x) {
            int index = x;
            this.func_75146_a(new Slot((IInventory)this.inventory, index, 8 + 18 * x, 142));
        }
    }

    void addPlayerInventorySlots() {
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                int index = 9 + y * 9 + x;
                int xpos = 8 + x * 18;
                int ypos = 84 + y * 18;
                this.func_75146_a(new Slot((IInventory)this.inventory, index, xpos, ypos));
            }
        }
    }

    public boolean func_75145_c(PlayerEntity player) {
        if (WorldUtils.isLogicalClient((Entity)player)) {
            return false;
        }
        ItemStack main = player.func_184614_ca();
        if (main.func_190926_b()) {
            return false;
        }
        return main == this.itemStackBeingHeld;
    }

    public ItemStack func_82846_b(PlayerEntity playerIn, int index) {
        return super.func_82846_b(playerIn, index);
    }

    public void func_75142_b() {
        if (!this.compositeItemInventory.isChanged()) {
            super.func_75142_b();
            return;
        }
        CompoundNBT nbt = this.itemStackBeingHeld.func_196082_o();
        int dirtyCounter = nbt.func_74762_e("dirtyCounter");
        nbt.func_74768_a("dirtyCounter", dirtyCounter + 1);
        this.itemStackBeingHeld.func_77982_d(nbt);
    }

    public CompositeMagicItemItemStackHandler getCompositeItemInventory() {
        return this.compositeItemInventory;
    }
}

