/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.inventory.container;

import bassebombecraft.item.ItemUtils;
import bassebombecraft.item.composite.GenericCompositeNullItem;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Sequence2;
import java.util.ArrayList;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public class CompositeMagicItemItemStackHandler
extends ItemStackHandler {
    static final String ITEM_NAME_PREFIX = "bassebombecraft:";
    boolean isChanged = true;
    Item[] signatures = new Item[6];
    Operator2 operator;
    String compositeName;
    int compositeLength;
    int inventoryIndex;

    public CompositeMagicItemItemStackHandler(int size) {
        super(size);
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        if (stack.func_190926_b()) {
            return false;
        }
        Item item = stack.func_77973_b();
        return ItemUtils.isTypeCompositeItem(item);
    }

    protected void onContentsChanged(int slot) {
        this.isChanged = true;
        this.inventoryIndex = this.findInventoryComposites();
        if (this.isInventoryContainingComposites(this.inventoryIndex)) {
            this.compositeLength = this.calculateCompositeLength(this.inventoryIndex);
            this.compositeLength = Math.min(this.compositeLength, 6);
            if (this.hasSignatureChanged(this.inventoryIndex, this.compositeLength)) {
                this.configureOperators(this.inventoryIndex, this.compositeLength);
                this.createCompositeName(this.inventoryIndex, this.compositeLength);
            }
        } else {
            this.compositeLength = 0;
        }
    }

    public boolean isChanged() {
        boolean retval = this.isChanged;
        this.isChanged = false;
        return retval;
    }

    int findInventoryComposites() {
        int size = this.stacks.size();
        for (int index = 0; index < size; ++index) {
            ItemStack inventoryStack = this.getStackInSlot(index);
            if (inventoryStack.func_190926_b() || !this.isCompositeItem(index)) continue;
            return index;
        }
        return -1;
    }

    boolean isInventoryContainingComposites(int inventoryIndex) {
        return inventoryIndex != -1;
    }

    boolean isCompositeItem(int index) {
        ItemStack stack = this.getStackInSlot(index);
        Item inventoryItem = stack.func_77973_b();
        return ItemUtils.isTypeCompositeItem(inventoryItem);
    }

    int calculateCompositeLength(int inventoryIndex) {
        int length = 0;
        int size = this.stacks.size();
        for (int index = inventoryIndex; index < size; ++index) {
            if (!this.isCompositeItem(index)) {
                return length;
            }
            ++length;
        }
        return length;
    }

    boolean hasSignatureChanged(int inventoryIndex, int length) {
        boolean retval = false;
        for (int index = 0; index < length; ++index) {
            boolean hasChanged = this.hasSignatureChangedAtSlot(inventoryIndex + index, index);
            if (!hasChanged) continue;
            this.updateSignatureAtSlot(inventoryIndex, index);
            retval = true;
        }
        return retval;
    }

    boolean hasSignatureChangedAtSlot(int inventoryIndex, int signatureIndex) {
        int inventoryItemHash;
        ItemStack inventoryStack = this.getStackInSlot(inventoryIndex);
        Item inventoryItem = inventoryStack.func_77973_b();
        Item signatureItem = this.signatures[signatureIndex];
        if (signatureItem == null) {
            this.signatures[signatureIndex] = inventoryItem;
            return true;
        }
        int signatureHash = signatureItem.hashCode();
        return signatureHash != (inventoryItemHash = inventoryItem.hashCode());
    }

    void updateSignatureAtSlot(int inventoryIndex, int signatureIndex) {
        Item inventoryItem;
        ItemStack inventoryStack = this.getStackInSlot(inventoryIndex);
        this.signatures[signatureIndex] = inventoryItem = inventoryStack.func_77973_b();
    }

    void configureOperators(int inventoryIndex, int length) {
        ArrayList<Operator2> opList = new ArrayList<Operator2>();
        for (int index = 0; index < length; ++index) {
            this.configureOperator(opList, inventoryIndex + index);
        }
        Operator2[] opArray = opList.toArray(new Operator2[length]);
        this.operator = new Sequence2(opArray);
    }

    void configureOperator(ArrayList<Operator2> opList, int index) {
        ItemStack inventoryStack = this.getStackInSlot(index);
        Item inventoryItem = inventoryStack.func_77973_b();
        GenericCompositeNullItem compositeNullItem = (GenericCompositeNullItem)inventoryItem;
        Operator2 operator = compositeNullItem.createOperator();
        opList.add(operator);
    }

    public Operator2 getOperator() {
        return this.operator;
    }

    void createCompositeName(int inventoryIndex, int length) {
        StringBuilder name = new StringBuilder();
        for (int index = 0; index < length; ++index) {
            ItemStack inventoryStack = this.getStackInSlot(inventoryIndex + index);
            Item inventoryItem = inventoryStack.func_77973_b();
            name.append("-");
            String itemName = inventoryItem.getRegistryName().toString();
            String removedPrefixName = itemName.substring(ITEM_NAME_PREFIX.length());
            name.append(removedPrefixName);
        }
        this.compositeName = name.toString();
    }

    public String getCompositeName() {
        return this.compositeName;
    }

    public int getCompositeLength() {
        return this.compositeLength;
    }

    public int getCompositeInventoryIndex() {
        return this.inventoryIndex;
    }
}

