/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.build.tower;

import bassebombecraft.item.action.build.BuildUtils;
import bassebombecraft.item.action.build.tower.BuildMaterial;
import bassebombecraft.item.action.build.tower.Builder;
import bassebombecraft.item.action.build.tower.Room;
import bassebombecraft.item.action.build.tower.StairsMaterial;
import bassebombecraft.item.action.build.tower.Wall;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.Structure;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.StairsBlock;
import net.minecraft.state.Property;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;

public class DefaultBuilder
implements Builder {
    static final BlockState STAIRS_STATE = (BlockState)Blocks.field_150390_bg.func_176223_P().func_206870_a((Property)StairsBlock.field_176309_a, (Comparable)Direction.SOUTH);
    StairsMaterial stairsMaterial;
    Random random;

    public DefaultBuilder(Random random) {
        this.random = random;
        this.stairsMaterial = BuildUtils.createInstance(STAIRS_STATE, Blocks.field_150390_bg, Blocks.field_196696_di);
    }

    @Override
    public void buildRoom(Room room, Structure structure) {
        BlockPos size = room.getSize();
        BlockPos offset = room.getOffset();
        BuildMaterial material = room.getMaterial();
        int height = size.func_177956_o();
        int width = size.func_177958_n();
        int depth = size.func_177952_p();
        int xoffset = offset.func_177958_n();
        int yoffset = offset.func_177956_o();
        int zoffset = offset.func_177952_p();
        BlockPos roomOffset = new BlockPos(xoffset, yoffset, zoffset);
        BlockPos roomSize = new BlockPos(width, height, depth);
        structure.add(new ChildStructure(roomOffset, roomSize, material.getBlock(), material.getState()));
        height = size.func_177956_o() - 2;
        width = size.func_177958_n() - 2;
        depth = size.func_177952_p() - 2;
        xoffset = offset.func_177958_n() + 1;
        yoffset = offset.func_177956_o() + 1;
        roomOffset = new BlockPos(xoffset, yoffset, ++zoffset);
        roomSize = new BlockPos(width, height, depth);
        structure.add(ChildStructure.createAirStructure(roomOffset, roomSize));
    }

    @Override
    public void buildFloor(Room room, Structure structure) {
        BlockPos size = room.getSize();
        BlockPos offset = room.getOffset();
        BlockPos floorSize = size.func_177982_a(-2, 1 - size.func_177956_o(), -2);
        BlockPos floorOffset = offset.func_177982_a(1, 0, 1);
        BuildMaterial material = BuildUtils.selectFloorMaterial(this.random);
        structure.add(new ChildStructure(floorOffset, floorSize, material.getBlock(), material.getState()));
    }

    @Override
    public void buildMobSpawner(Room room, Structure structure) {
        BlockPos size = room.getSize();
        BlockPos offset = room.getOffset();
        if (size.func_177958_n() < 5) {
            return;
        }
        if (size.func_177952_p() < 5) {
            return;
        }
        BlockPos location = offset.func_177982_a(size.func_177958_n() / 2, 1, size.func_177952_p() / 2);
        BuildUtils.addMobSpawner(structure, location);
    }

    @Override
    public void buildStairs(Room room, Structure structure, Structure postStructure) {
        BlockPos size = room.getSize();
        BlockPos offset = room.getOffset();
        int roomHeight = size.func_177956_o();
        boolean hasSpaceForStairs = this.hasSpaceForStairs(size);
        BlockPos stairOffset = null;
        if (room.getType().equals((Object)Room.RoomType.NW)) {
            Wall[] walls = room.getExternalWalls();
            Wall wall = walls[1];
            BlockPos wallOffset = wall.getOffset();
            stairOffset = new BlockPos(wallOffset.func_177958_n() + 1, wallOffset.func_177956_o(), wallOffset.func_177952_p() + 2);
        } else {
            Wall[] walls = room.getExternalWalls();
            int stairsTypeDependentOffset = 0;
            stairsTypeDependentOffset = hasSpaceForStairs ? -2 : -3;
            Wall wall = walls[1];
            BlockPos wallOffset = wall.getOffset();
            stairOffset = new BlockPos(wallOffset.func_177958_n() + stairsTypeDependentOffset, wallOffset.func_177956_o(), wallOffset.func_177952_p() + 2);
        }
        if (hasSpaceForStairs) {
            BuildUtils.addSolidStairsUp(roomHeight, this.stairsMaterial, structure, postStructure, stairOffset);
            return;
        }
        BuildUtils.addSpiralStairsUp(roomHeight, this.stairsMaterial, structure, postStructure, stairOffset);
    }

    boolean hasSpaceForStairs(BlockPos size) {
        int requiredZSpace = size.func_177956_o() + 3;
        return requiredZSpace < size.func_177952_p();
    }

    @Override
    public void buildWindow(Wall wall, Structure structure) {
        BlockPos offset = wall.getOffset();
        BlockPos roomSize = wall.getRoom().getSize();
        int minRoomSize = 4;
        switch (wall.getOrientation()) {
            case X: {
                if (roomSize.func_177958_n() <= minRoomSize) {
                    return;
                }
            }
            case Z: {
                if (roomSize.func_177952_p() > minRoomSize) break;
                return;
            }
        }
        int windowXZSize = 2;
        int windowYSize = 2;
        int windowXZOffset = this.calculateWindowOffset(wall, roomSize);
        int windowYOffset = roomSize.func_177956_o() - windowYSize - 1;
        BuildMaterial material = BuildUtils.selectWindowMaterial(this.random);
        switch (wall.getOrientation()) {
            case X: {
                int randomFactor = roomSize.func_177958_n() - windowXZSize - windowXZOffset;
                int windowXOffset = windowXZOffset + this.random.nextInt(randomFactor);
                BlockPos windowOffset = offset.func_177982_a(windowXOffset, windowYOffset, 0);
                BlockPos windowSize = new BlockPos(windowXZSize, windowYSize, 1);
                structure.add(new ChildStructure(windowOffset, windowSize, material.getBlock(), material.getState()));
                return;
            }
            case Z: {
                int randomFactor = roomSize.func_177952_p() - windowXZSize - windowXZOffset;
                int windowZOffset = windowXZOffset + this.random.nextInt(randomFactor);
                BlockPos windowOffset = offset.func_177982_a(0, windowYOffset, windowZOffset);
                BlockPos windowSize = new BlockPos(1, windowYSize, windowXZSize);
                structure.add(new ChildStructure(windowOffset, windowSize, material.getBlock(), material.getState()));
                return;
            }
        }
    }

    int calculateWindowOffset(Wall wall, BlockPos roomSize) {
        switch (wall.getOrientation()) {
            case X: {
                if (roomSize.func_177958_n() == 4) {
                    return 1;
                }
                if (roomSize.func_177958_n() > 4) {
                    return 2;
                }
            }
            case Z: {
                if (roomSize.func_177952_p() == 4) {
                    return 1;
                }
                if (roomSize.func_177952_p() <= 4) break;
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void buildDoor(Wall wall, Structure structure) {
        int minRoomSize = 4;
        int doorXZSize = 4;
        int doorYSize = 4;
        BlockPos offset = wall.getOffset();
        BlockPos roomSize = wall.getRoom().getSize();
        switch (wall.getOrientation()) {
            case X: {
                if (roomSize.func_177958_n() <= minRoomSize) {
                    return;
                }
            }
            case Z: {
                if (roomSize.func_177952_p() > minRoomSize) break;
                return;
            }
        }
        int doorXZOffset = this.calculateDoorOffset(wall, roomSize);
        switch (wall.getOrientation()) {
            case X: {
                int doorXOffset = doorXZOffset;
                int randomFactor = roomSize.func_177958_n() - doorXZSize - doorXZOffset - doorXZOffset;
                if (randomFactor > 0) {
                    doorXOffset = doorXZOffset + this.random.nextInt(randomFactor);
                }
                BlockPos doorOffset = offset.func_177982_a(doorXOffset, 1, 0);
                BlockPos doorSize = new BlockPos(doorXZSize, doorYSize, 1);
                BuildUtils.addOakFencedDoorEntryFront(structure, doorOffset);
                return;
            }
            case Z: {
                int doorZOffset = doorXZOffset;
                int randomFactor = roomSize.func_177952_p() - doorXZSize - doorXZOffset - doorXZOffset;
                if (randomFactor > 0) {
                    doorZOffset = doorXZOffset + this.random.nextInt(randomFactor);
                }
                BlockPos doorOffset = offset.func_177982_a(0, 1, doorZOffset);
                BlockPos doorSize = new BlockPos(1, doorYSize, doorXZSize);
                BuildUtils.addOakFencedDoorEntryFrontSideways(structure, doorOffset);
                return;
            }
        }
    }

    int calculateDoorOffset(Wall wall, BlockPos roomSize) {
        switch (wall.getOrientation()) {
            case X: {
                if (roomSize.func_177958_n() == 5) {
                    return 0;
                }
                if (roomSize.func_177958_n() == 6) {
                    return 1;
                }
                if (roomSize.func_177958_n() > 6) {
                    return 2;
                }
            }
            case Z: {
                if (roomSize.func_177952_p() == 5) {
                    return 0;
                }
                if (roomSize.func_177952_p() == 6) {
                    return 1;
                }
                if (roomSize.func_177952_p() <= 6) break;
                return 2;
            }
        }
        return 0;
    }

    @Override
    public void buildTop(BlockPos offset, Block material, Structure structure) {
        BlockPos size = new BlockPos(10, 1, 10);
        offset = offset.func_177982_a(-5, 0, -5);
        structure.add(new ChildStructure(offset, size, material));
    }
}

