/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import java.util.List;
import net.minecraft.block.BlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class Pinkynize
implements InventoryItemActionStrategy {
    public static final String NAME = Pinkynize.class.getSimpleName();
    final int spiralSize = (Integer)ModConfiguration.pinkynizeSpiralSize.get();
    int colorCounter = 0;
    int spiralCounter;
    BlockPos spiralCenter;
    List<BlockPos> spiralCoordinates = GeometryUtils.calculateSpiral(this.spiralSize, this.spiralSize);

    @Override
    public boolean applyOnlyIfSelected() {
        return true;
    }

    @Override
    public boolean shouldApplyEffect(Entity target, boolean targetIsInvoker) {
        return targetIsInvoker;
    }

    @Override
    public void applyEffect(LivingEntity target, World world, LivingEntity invoker) {
        ++this.colorCounter;
        BlockPos targetPosition = this.calculatePostion((Entity)target);
        BlockPos groundPosition = GeometryUtils.locateGroundBlockPos(targetPosition, 256, world);
        BlockState woolBlock = BlockUtils.selectPinkColoredWool(this.colorCounter);
        BlockDirective directive = BlockDirective.getInstance(groundPosition, woolBlock.func_177230_c(), false, world);
        directive.setState(BlockUtils.selectPinkColoredWool(this.colorCounter));
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        repository.add(directive);
    }

    BlockPos calculatePostion(Entity target) {
        if (this.spiralCenter == null) {
            this.initializeSpiral(target);
        }
        if (!this.spiralCenter.equals((Object)target.func_233580_cy_())) {
            this.initializeSpiral(target);
        }
        if (this.spiralCounter >= this.spiralCoordinates.size()) {
            return target.func_233580_cy_();
        }
        BlockPos spiralCoord = this.spiralCoordinates.get(this.spiralCounter);
        int x = this.spiralCenter.func_177958_n() + spiralCoord.func_177958_n();
        int y = this.spiralCenter.func_177956_o();
        int z = this.spiralCenter.func_177952_p() + spiralCoord.func_177952_p();
        BlockPos groundCandidate = new BlockPos(x, y, z);
        ++this.spiralCounter;
        return groundCandidate;
    }

    void initializeSpiral(Entity target) {
        this.spiralCounter = 0;
        this.spiralCenter = new BlockPos(target.func_226277_ct_(), target.func_226278_cu_(), target.func_226281_cx_());
    }
}

