/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.event.frequency.FrequencyRepository;
import bassebombecraft.event.particle.DefaultParticleRendering;
import bassebombecraft.event.particle.ParticleRendering;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.item.action.RightClickedItemAction;
import bassebombecraft.item.action.mist.block.BlockMistActionStrategy;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class GenericBlockMist
implements RightClickedItemAction {
    static final float INVOCATION_DIST = 4.0f;
    int ticksCounter = 0;
    Vector3d[] mistPositions;
    Vector3d[] mistDirections;
    LivingEntity entity;
    Vector3d entityLook;
    boolean isActive = false;
    BlockMistActionStrategy strategy;

    public GenericBlockMist(BlockMistActionStrategy strategy) {
        this.strategy = strategy;
    }

    @Override
    public void onRightClick(World world, LivingEntity entity) {
        try {
            this.entity = entity;
            this.isActive = true;
            this.ticksCounter = 0;
            this.initializeMistPostition(world, entity);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    @Override
    public void onUpdate(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        try {
            if (!this.isActive()) {
                return;
            }
            this.render(worldIn);
            FrequencyRepository repository = BassebombeCraft.getProxy().getServerFrequencyRepository();
            if (repository.isActive(3)) {
                this.applyEffect(worldIn);
            }
            if (this.ticksCounter > this.strategy.getEffectDuration()) {
                this.isActive = false;
                this.entity = null;
                return;
            }
            ++this.ticksCounter;
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    boolean isActive() {
        return this.isActive;
    }

    void initializeMistPostition(World world, LivingEntity entity) {
        this.mistDirections = new Vector3d[this.strategy.getNumberMists()];
        this.mistPositions = new Vector3d[this.strategy.getNumberMists()];
        Vector3d entityLook = entity.func_70676_i(1.0f);
        Vector3d entityPos = new Vector3d(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_());
        double offsetAngle = (double)(this.strategy.getNumberMists() - 1) * this.strategy.getMistAngle() * -0.5;
        for (int index = 0; index < this.strategy.getNumberMists(); ++index) {
            Vector3d rotatedLookVector;
            double angle = offsetAngle + (double)index * this.strategy.getMistAngle();
            this.mistDirections[index] = rotatedLookVector = GeometryUtils.rotateUnitVectorAroundYAxisAtOrigin(angle, entityLook);
            Vector3d entityLookXn = new Vector3d(rotatedLookVector.field_72450_a * 4.0, rotatedLookVector.field_72448_b * 4.0, rotatedLookVector.field_72449_c * 4.0);
            double x = entityLookXn.field_72450_a;
            float y = entity.func_70047_e();
            double z = entityLookXn.field_72449_c;
            this.mistPositions[index] = entityPos.func_72441_c(x, (double)y, z);
        }
    }

    void applyEffect(World world) {
        for (Vector3d mistPosition : this.mistPositions) {
            BlockPos target = new BlockPos(mistPosition);
            this.strategy.applyEffectToBlock(target, world);
        }
    }

    void render(World world) {
        this.updateMistPositions();
        for (Vector3d mistPosition : this.mistPositions) {
            this.renderMist(mistPosition);
        }
    }

    void renderMist(Vector3d mistPosition) {
        try {
            BlockPos pos = new BlockPos(mistPosition);
            ParticleRendering particle = DefaultParticleRendering.getInstance(pos, this.strategy.getRenderingInfo());
            BassebombeCraft.getProxy().getNetworkChannel().sendAddParticleRenderingPacket(particle);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    void updateMistPositions() {
        int index = 0;
        for (Vector3d mistPosition : this.mistPositions) {
            Vector3d mistDirection = this.mistDirections[index];
            this.mistPositions[index] = mistPosition.func_178787_e(mistDirection);
            ++index;
        }
    }
}

