/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.block;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.item.action.mist.block.BlockMistActionStrategy;
import net.minecraft.block.BlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class RainbowSpiralMist
implements BlockMistActionStrategy {
    public static final String NAME = RainbowSpiralMist.class.getSimpleName();
    ParticleRenderingInfo info = ConfigUtils.createInfoFromConfig(ModConfiguration.rainbowSpiralMistParticleInfo);
    int duration = (Integer)ModConfiguration.rainbowSpiralMistDuration.get();
    int colorCounter = 0;

    @Override
    public void applyEffectToBlock(BlockPos target, World world) {
        ++this.colorCounter;
        BlockState woolBlock = BlockUtils.selectRainbowColoredWool(this.colorCounter);
        BlockDirective directive = BlockDirective.getInstance(target, woolBlock.func_177230_c(), false, world);
        directive.setState(BlockUtils.selectRainbowColoredWool(this.colorCounter));
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        repository.add(directive);
    }

    @Override
    public int getEffectDuration() {
        return this.duration;
    }

    @Override
    public int getNumberMists() {
        return 1;
    }

    @Override
    public double getMistAngle() {
        return 0.0;
    }

    @Override
    public boolean isOneShootEffect() {
        return false;
    }

    @Override
    public ParticleRenderingInfo getRenderingInfo() {
        return this.info;
    }

    @Override
    public int getSpiralOffset() {
        return 0;
    }
}

