/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.action.mist.entity;

import bassebombecraft.event.particle.DefaultParticleRenderingInfo;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.mist.entity.EntityMistActionStrategy;
import bassebombecraft.world.WorldUtils;
import net.minecraft.entity.LivingEntity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public class LightningBoltMist
implements EntityMistActionStrategy {
    static final int EFFECT_DURATION = 500;
    ParticleRenderingInfo info;

    public LightningBoltMist() {
        float r = 0.75f;
        float g = 0.75f;
        float b = 0.75f;
        int numbers = 5;
        BasicParticleType type = ParticleTypes.field_197613_f;
        int duration = 20;
        double speed = 0.1;
        this.info = DefaultParticleRenderingInfo.getInstance(type, numbers, duration, r, g, b, speed);
    }

    @Override
    public void applyEffectToEntity(LivingEntity target, Vector3d mistPos, LivingEntity invoker) {
        World world = target.func_130014_f_();
        AxisAlignedBB aabb = target.func_174813_aQ();
        BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
        BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
        BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(pos -> WorldUtils.addLightningAtBlockPos(world, pos));
    }

    @Override
    public int getEffectDuration() {
        return 500;
    }

    @Override
    public boolean isEffectAppliedToInvoker() {
        return false;
    }

    @Override
    public boolean isStationary() {
        return true;
    }

    @Override
    public boolean isOneShootEffect() {
        return false;
    }

    @Override
    public int getEffectRange() {
        return 5;
    }

    @Override
    public ParticleRenderingInfo getRenderingInfos() {
        return this.info;
    }
}

