/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.composite;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.config.ItemConfig;
import bassebombecraft.item.ItemUtils;
import bassebombecraft.operator.Operator2;
import bassebombecraft.world.WorldUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.Hand;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class GenericCompositeNullItem
extends Item {
    int coolDown;
    protected String tooltip;

    public GenericCompositeNullItem(ItemConfig config) {
        super(new Item.Properties().func_200916_a(BassebombeCraft.getItemGroup()));
        this.coolDown = (Integer)config.cooldown.get();
        this.tooltip = (String)config.tooltip.get();
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, Hand handIn) {
        if (WorldUtils.isLogicalClient(worldIn)) {
            return super.func_77659_a(worldIn, playerIn, handIn);
        }
        BassebombeCraft.getProxy().postItemUsage(this.getRegistryName().toString(), playerIn.func_146103_bH().getName());
        CooldownTracker tracker = playerIn.func_184811_cZ();
        tracker.func_185145_a((Item)this, this.coolDown);
        return new ActionResult(ActionResultType.SUCCESS, (Object)playerIn.func_184586_b(handIn));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        String typeName = ItemUtils.resolveCompositeItemTypeFromString(this);
        tooltip.add((ITextComponent)new TranslationTextComponent(TextFormatting.GREEN + this.tooltip));
        tooltip.add((ITextComponent)new TranslationTextComponent("genericcompositenullitem.type", new Object[]{typeName}));
        tooltip.add((ITextComponent)new TranslationTextComponent("genericcompositenullitem.usage", ModConstants.NULL_I18N_ARGS).func_240699_a_(TextFormatting.DARK_BLUE));
    }

    public abstract Operator2 createOperator();
}

