/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.item.inventory;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ConfigUtils;
import bassebombecraft.config.InventoryItemConfig;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.event.particle.ParticleRenderingInfo;
import bassebombecraft.item.action.inventory.InventoryItemActionStrategy;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.operator.client.rendering.AddParticlesFromPosAtClient2;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.world.WorldUtils;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.CooldownTracker;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class GenericInventoryItem
extends Item {
    InventoryItemActionStrategy strategy;
    int coolDown;
    String tooltip;
    int range;
    Ports addParticlesPorts;
    Operator2 addParticlesOp;

    public GenericInventoryItem(InventoryItemConfig config, InventoryItemActionStrategy strategy) {
        super(new Item.Properties().func_200916_a(BassebombeCraft.getItemGroup()));
        this.strategy = strategy;
        this.coolDown = (Integer)config.cooldown.get();
        this.tooltip = (String)config.tooltip.get();
        this.range = (Integer)config.range.get();
        ParticleRenderingInfo info = ConfigUtils.createInfoFromConfig(config.particles);
        this.addParticlesOp = new AddParticlesFromPosAtClient2(info);
        this.addParticlesPorts = DefaultPorts.getInstance();
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (WorldUtils.isLogicalClient(worldIn)) {
            return;
        }
        if (!this.isInHotbar(itemSlot)) {
            return;
        }
        boolean shouldActivateFromOffHand = false;
        if (PlayerUtils.isTypePlayerEntity(entityIn)) {
            PlayerEntity player = (PlayerEntity)entityIn;
            shouldActivateFromOffHand = PlayerUtils.isItemHeldInOffHand(player, stack);
        }
        boolean shouldActivateFromHotbar = false;
        if (this.strategy.applyOnlyIfSelected()) {
            if (isSelected) {
                shouldActivateFromHotbar = true;
            }
        } else {
            shouldActivateFromHotbar = true;
        }
        if (!shouldActivateFromOffHand && !shouldActivateFromHotbar) {
            return;
        }
        if (!EntityUtils.isTypeLivingEntity(entityIn)) {
            return;
        }
        if (!PlayerUtils.isTypePlayerEntity(entityIn)) {
            return;
        }
        PlayerEntity player = (PlayerEntity)entityIn;
        if (player.func_184811_cZ().func_185141_a((Item)this)) {
            return;
        }
        CooldownTracker tracker = player.func_184811_cZ();
        tracker.func_185145_a((Item)this, this.coolDown);
        BassebombeCraft.getProxy().postItemUsage(this.getRegistryName().toString(), player.func_146103_bH().getName());
        this.applyEffect(worldIn, (LivingEntity)entityIn);
    }

    boolean isInHotbar(int itemSlot) {
        if (itemSlot < 0) {
            return false;
        }
        return itemSlot <= 8;
    }

    void applyEffect(World world, LivingEntity invokingEntity) {
        AxisAlignedBB aabb = new AxisAlignedBB(invokingEntity.func_226277_ct_() - (double)this.range, invokingEntity.func_226278_cu_() - (double)this.range, invokingEntity.func_226281_cx_() - (double)this.range, invokingEntity.func_226277_ct_() + (double)this.range, invokingEntity.func_226278_cu_() + (double)this.range, invokingEntity.func_226281_cx_() + (double)this.range);
        List entities = world.func_217357_a(LivingEntity.class, aabb);
        for (LivingEntity foundEntity : entities) {
            boolean isInvoker;
            if (!this.strategy.shouldApplyEffect((Entity)foundEntity, isInvoker = PlayerUtils.hasIdenticalUniqueID((Entity)invokingEntity, (Entity)foundEntity))) continue;
            this.strategy.applyEffect(foundEntity, world, invokingEntity);
            this.addParticles(foundEntity.func_213303_ch());
        }
    }

    void addParticles(Vector3d position) {
        BlockPos pos = new BlockPos(position);
        this.addParticlesPorts.setBlockPosition1(pos);
        Operators2.run(this.addParticlesPorts, this.addParticlesOp);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        TranslationTextComponent text = new TranslationTextComponent(TextFormatting.GREEN + this.tooltip);
        tooltip.add((ITextComponent)text);
    }

    public int getCoolDown() {
        return this.coolDown;
    }
}

