/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.network.packet;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.client.event.rendering.effect.GraphicalEffectRepository;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.network.NetworkEvent;

public class AddGraphicalEffect {
    int duration;
    int sourceEntityId;
    int targetEntityId;
    GraphicalEffectRepository.Effect effect;

    public AddGraphicalEffect(PacketBuffer buf) {
        this.sourceEntityId = buf.readInt();
        this.targetEntityId = buf.readInt();
        this.duration = buf.readInt();
        this.effect = GraphicalEffectRepository.Effect.valueOf(buf.func_218666_n());
    }

    public AddGraphicalEffect(Entity source, Entity target, int duration, GraphicalEffectRepository.Effect effect) {
        this.sourceEntityId = source.func_145782_y();
        this.targetEntityId = target.func_145782_y();
        this.duration = duration;
        this.effect = effect;
    }

    public void encode(PacketBuffer buf) {
        buf.writeInt(this.sourceEntityId);
        buf.writeInt(this.targetEntityId);
        buf.writeInt(this.duration);
        buf.func_180714_a(this.effect.name());
    }

    public void handle(Supplier<NetworkEvent.Context> context) {
        NetworkEvent.Context ctx = context.get();
        ctx.enqueueWork(() -> this.handlePacket());
        ctx.setPacketHandled(true);
    }

    void handlePacket() {
        try {
            Minecraft mcClient = Minecraft.func_71410_x();
            Entity target = mcClient.field_71441_e.func_73045_a(this.targetEntityId);
            if (target == null) {
                return;
            }
            GraphicalEffectRepository repository = BassebombeCraft.getProxy().getClientGraphicalEffectRepository();
            Entity source = mcClient.field_71441_e.func_73045_a(this.sourceEntityId);
            if (source != null) {
                repository.add(source, target, this.duration, this.effect);
                return;
            }
            repository.addUnresolvedSource(this.sourceEntityId, target, this.duration, this.effect);
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }
}

