/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.block;

import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class CalculateSpiralPosition2
implements Operator2 {
    List<BlockPos> spiralCoordinates;
    Function<Ports, BlockPos> fnGetBlockPos;
    BiConsumer<Ports, BlockPos> bcSetBlockPos;
    Function<Ports, World> fnGetWorld;

    public CalculateSpiralPosition2(int spiralSize, Function<Ports, BlockPos> fnGetBlockPos, BiConsumer<Ports, BlockPos> bcSetBlockPos, Function<Ports, World> fnGetWorld) {
        this.fnGetBlockPos = fnGetBlockPos;
        this.bcSetBlockPos = bcSetBlockPos;
        this.fnGetWorld = fnGetWorld;
        this.spiralCoordinates = GeometryUtils.calculateSpiral(spiralSize, spiralSize);
    }

    public CalculateSpiralPosition2(int spiralSize) {
        this(spiralSize, DefaultPorts.getFnGetBlockPosition1(), DefaultPorts.getBcSetBlockPosition2(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        BlockPos center = Operators2.applyV(this.fnGetBlockPos, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        BlockPos spiralCoord = this.spiralCoordinates.get(ports.getCounter());
        int x = center.func_177958_n() + spiralCoord.func_177958_n();
        int y = center.func_177956_o();
        int z = center.func_177952_p() + spiralCoord.func_177952_p();
        BlockPos candidate = new BlockPos(x, y, z);
        BlockPos position = GeometryUtils.locateGroundBlockPos(candidate, 256, world);
        this.bcSetBlockPos.accept(ports, position);
    }
}

