/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.attribute.RegisteredAttributes;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.potion.effect.RegisteredEffects;
import java.util.Random;
import java.util.function.Function;
import java.util.stream.IntStream;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.world.World;

public class Respawn2
implements Operator2 {
    public static final String NAME = Respawn2.class.getSimpleName();
    Function<Ports, LivingEntity> fnGetDeadEntity;

    public Respawn2(Function<Ports, LivingEntity> fnGetDeadEntity) {
        this.fnGetDeadEntity = fnGetDeadEntity;
    }

    public Respawn2() {
        this(DefaultPorts.getFnGetLivingEntity1());
    }

    @Override
    public void run(Ports ports) {
        LivingEntity deadEntity = Operators2.applyV(this.fnGetDeadEntity, ports);
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        int entities = Math.max((Integer)ModConfiguration.respawnMinEntities.get(), random.nextInt((Integer)ModConfiguration.respawnMaxEntities.get()));
        IntStream.rangeClosed(1, entities).forEach(n -> this.spawnEntity(deadEntity));
    }

    void spawnEntity(LivingEntity deadEntity) {
        World world = deadEntity.func_130014_f_();
        EntityType type = deadEntity.func_200600_R();
        Entity spawnedEntity = type.func_200721_a(world);
        int spawnArea = (Integer)ModConfiguration.respawnSpawnArea.get();
        EntityUtils.setRandomSpawnPosition(deadEntity.func_233580_cy_(), EntityUtils.calculateRandomYaw(), spawnArea, spawnedEntity);
        if (EntityUtils.isTypeLivingEntity(spawnedEntity)) {
            EntityUtils.setAttribute((LivingEntity)spawnedEntity, (Attribute)RegisteredAttributes.IS_RESPAWNED_ATTRIBUTE.get(), 1.0);
        }
        world.func_217376_c(spawnedEntity);
        LivingEntity livingEntity = (LivingEntity)spawnedEntity;
        livingEntity.func_195064_c(this.createEffect());
    }

    EffectInstance createEffect() {
        return new EffectInstance((Effect)RegisteredEffects.AGGRO_PLAYER_EFFECT.get(), Integer.MAX_VALUE);
    }
}

