/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;

public class Bounce2
implements Operator2 {
    public static final String NAME = Bounce2.class.getSimpleName();
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, Entity> fnGetProjectile;

    public Bounce2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, Entity> fnGetProjectile) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetProjectile = fnGetProjectile;
    }

    public Bounce2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnGetEntity1());
    }

    @Override
    public void run(Ports ports) {
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        Entity projectile = Operators2.applyV(this.fnGetProjectile, ports);
        Vector3d motionVector = projectile.func_213322_ci();
        if (motionVector == null) {
            return;
        }
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            Direction impactFace = blockResult.func_216354_b();
            Direction.Axis impactAxis = impactFace.func_176740_k();
            Vector3d bouncedVector = this.bounceMotionVector(impactAxis, motionVector);
            projectile.func_213317_d(bouncedVector);
        }
    }

    Vector3d bounceMotionVector(Direction.Axis impactAxis, Vector3d motionVector) {
        switch (impactAxis) {
            case X: {
                return motionVector.func_216372_d(-1.0, 1.0, 1.0);
            }
            case Y: {
                return motionVector.func_216372_d(1.0, -1.0, 1.0);
            }
            case Z: {
                return motionVector.func_216372_d(1.0, 1.0, -1.0);
            }
        }
        return motionVector;
    }
}

