/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.ModConstants;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import java.util.List;
import java.util.function.Function;
import net.minecraft.util.Direction;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class Dig2
implements Operator2 {
    public static final String NAME = Dig2.class.getSimpleName();
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public Dig2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public Dig2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            Direction impactDirection = blockResult.func_216354_b();
            Direction rotatedDirection = impactDirection.func_176746_e().func_176746_e();
            PlayerDirection playerDirection = GeometryUtils.convertToPlayerDirection(rotatedDirection);
            BlockPos offset = blockResult.func_216350_a();
            CompositeStructure composite = new CompositeStructure();
            this.createExcavatedStructure(composite);
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, playerDirection, composite, false, world);
            BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
            repository.addAll(directives);
        }
    }

    void createExcavatedStructure(CompositeStructure composite) {
        int holeSize = (Integer)ModConfiguration.digHoleSize.get();
        BlockPos size = new BlockPos(holeSize, holeSize, holeSize);
        composite.add(ChildStructure.createAirStructure(ModConstants.ORIGIN_BLOCK_POS, size));
    }
}

