/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.event.block.BlockDirectivesRepository;
import bassebombecraft.geom.BlockDirective;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import bassebombecraft.player.PlayerDirection;
import bassebombecraft.structure.ChildStructure;
import bassebombecraft.structure.CompositeStructure;
import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class DigMobHole2
implements Operator2 {
    public static final String NAME = DigMobHole2.class.getSimpleName();
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public DigMobHole2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public DigMobHole2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isEntityHit(result)) {
            if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
                return;
            }
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            int holeHeightExpansion = (Integer)ModConfiguration.digMobHoleHeightExpansion.get();
            AxisAlignedBB aabb = entity.func_174813_aQ();
            BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b - (double)holeHeightExpansion, aabb.field_72339_c);
            BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(pos -> this.registerBlockToDig(aabb, (BlockPos)pos, world));
            return;
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos offset = BlockUtils.calculatePosition(blockResult);
            CompositeStructure composite = new CompositeStructure();
            this.createVerticalStructure(composite);
            List<BlockDirective> directives = GeometryUtils.calculateBlockDirectives(offset, PlayerDirection.South, composite, false, world);
            BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
            repository.addAll(directives);
        }
    }

    void registerBlockToDig(AxisAlignedBB aabb, BlockPos pos, World world) {
        double translateY = aabb.field_72337_e - aabb.field_72338_b;
        BlockPos tranlatedPos = pos.func_177963_a(0.0, -translateY, 0.0);
        BlockDirective directive = BlockDirective.getInstance(tranlatedPos, Blocks.field_150350_a, false, world);
        BlockDirectivesRepository repository = BassebombeCraft.getProxy().getServerBlockDirectivesRepository();
        repository.add(directive);
    }

    void createVerticalStructure(CompositeStructure composite) {
        int noHitHoleDepth = (Integer)ModConfiguration.digMobHoleNoHitHoleDepth.get();
        int noHitholeHeight = (Integer)ModConfiguration.digMobHoleNoHitHoleHeight.get();
        int noHitholeWidth = (Integer)ModConfiguration.digMobHoleNoHitHoleWidth.get();
        BlockPos offset = new BlockPos(0, -noHitHoleDepth, 0);
        BlockPos size = new BlockPos(noHitholeWidth, noHitholeHeight, noHitHoleDepth);
        composite.add(ChildStructure.createAirStructure(offset, size));
    }
}

