/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.entity.raytraceresult;

import bassebombecraft.block.BlockUtils;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.projectile.ProjectileUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;

public class SpawnLavaBlock2
implements Operator2 {
    public static final String NAME = SpawnLavaBlock2.class.getSimpleName();
    Function<Ports, RayTraceResult> fnGetRayTraceResult;
    Function<Ports, World> fnGetWorld;

    public SpawnLavaBlock2(Function<Ports, RayTraceResult> fnGetRayTraceResult, Function<Ports, World> fnGetWorld) {
        this.fnGetRayTraceResult = fnGetRayTraceResult;
        this.fnGetWorld = fnGetWorld;
    }

    public SpawnLavaBlock2() {
        this(DefaultPorts.getFnGetRayTraceResult1(), DefaultPorts.getFnWorld1());
    }

    @Override
    public void run(Ports ports) {
        RayTraceResult result = Operators2.applyV(this.fnGetRayTraceResult, ports);
        World world = Operators2.applyV(this.fnGetWorld, ports);
        if (ProjectileUtils.isNothingHit(result)) {
            return;
        }
        if (ProjectileUtils.isEntityHit(result)) {
            if (!ProjectileUtils.isTypeEntityRayTraceResult(result)) {
                return;
            }
            Entity entity = ((EntityRayTraceResult)result).func_216348_a();
            AxisAlignedBB aabb = entity.func_174813_aQ();
            BlockPos min = new BlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c);
            BlockPos max = new BlockPos(aabb.field_72336_d, aabb.field_72337_e, aabb.field_72334_f);
            BlockPos.func_218281_b((BlockPos)min, (BlockPos)max).forEach(pos -> BlockUtils.setTemporaryBlock(world, pos, Blocks.field_150353_l, (Integer)ModConfiguration.spawnLavaBlockDuration.get()));
        }
        if (ProjectileUtils.isBlockHit(result)) {
            if (!ProjectileUtils.isTypeBlockRayTraceResult(result)) {
                return;
            }
            BlockRayTraceResult blockResult = (BlockRayTraceResult)result;
            BlockPos spawnPosition = BlockUtils.calculatePosition(blockResult);
            BlockUtils.setTemporaryBlock(world, spawnPosition, Blocks.field_150353_l, (Integer)ModConfiguration.spawnLavaBlockDuration.get());
        }
    }
}

