/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.projectile.path;

import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class RandomProjectilePath
implements Operator2 {
    public static final String NAME = RandomProjectilePath.class.getSimpleName();
    Function<Ports, Entity> fnGetProjectile;

    public RandomProjectilePath(Function<Ports, Entity> fnGetProjectile) {
        this.fnGetProjectile = fnGetProjectile;
    }

    public RandomProjectilePath() {
        this(DefaultPorts.getFnGetEntity1());
    }

    @Override
    public void run(Ports ports) {
        Entity projectile = Operators2.applyV(this.fnGetProjectile, ports);
        Vector3d motionVector = projectile.func_213322_ci();
        if (motionVector == null) {
            return;
        }
        long x = ports.getCounter();
        double angleDegrees = this.calculateAngle(x);
        if (angleDegrees == 0.0) {
            return;
        }
        float angleRadians = (float)Math.toRadians(angleDegrees);
        Vector3d newMotionVector = motionVector.func_178785_b(angleRadians);
        projectile.func_213293_j(newMotionVector.func_82615_a(), newMotionVector.func_82617_b(), newMotionVector.func_82616_c());
    }

    double calculateAngle(long x) {
        if (x < 5L) {
            return 0.0;
        }
        float oscValue = GeometryUtils.oscillateFloat(0.0f, 1.0f);
        return MathHelper.func_219799_g((float)oscValue, (float)-20.0f, (float)20.0f);
    }
}

