/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.operator.projectile.path;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.geom.GeometryUtils;
import bassebombecraft.operator.DefaultPorts;
import bassebombecraft.operator.Operator2;
import bassebombecraft.operator.Operators2;
import bassebombecraft.operator.Ports;
import java.util.Random;
import java.util.function.Function;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;

public class TeleportProjectilePath
implements Operator2 {
    static final int ANGLE = 45;
    public static final String NAME = TeleportProjectilePath.class.getSimpleName();
    Function<Ports, Entity> fnGetProjectile;

    public TeleportProjectilePath(Function<Ports, Entity> fnGetProjectile) {
        this.fnGetProjectile = fnGetProjectile;
    }

    public TeleportProjectilePath() {
        this(DefaultPorts.getFnGetEntity1());
    }

    @Override
    public void run(Ports ports) {
        Entity projectile = Operators2.applyV(this.fnGetProjectile, ports);
        Vector3d motionVector = projectile.func_213322_ci();
        if (motionVector == null) {
            return;
        }
        long x = ports.getCounter();
        float oscValue = GeometryUtils.oscillateFloat(0.0f, 1.0f);
        double angleDegrees = this.calculateAngle(x, oscValue);
        Random random = BassebombeCraft.getBassebombeCraft().getRandom();
        if (random.nextInt(5) < 4) {
            return;
        }
        float angleRadians = (float)Math.toRadians(angleDegrees);
        Vector3d newMotionVector = motionVector.func_178785_b(angleRadians);
        projectile.func_213293_j(newMotionVector.func_82615_a(), newMotionVector.func_82617_b(), newMotionVector.func_82616_c());
        float length = MathHelper.func_219799_g((float)oscValue, (float)1.0f, (float)3.0f);
        Vector3d deltaVector = newMotionVector.func_72432_b().func_186678_a((double)length);
        Vector3d newPosVector = projectile.func_213303_ch().func_178787_e(deltaVector);
        projectile.func_70634_a(newPosVector.func_82615_a(), newPosVector.func_82617_b(), newPosVector.func_82616_c());
    }

    double calculateAngle(long x, float oscValue) {
        if (x < 5L) {
            return 0.0;
        }
        return MathHelper.func_219799_g((float)oscValue, (float)-45.0f, (float)45.0f);
    }
}

