/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.player;

import bassebombecraft.player.PlayerDirection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;

public class PlayerUtils {
    public static double calculatePlayerFeetPositition(PlayerEntity player) {
        double playerFeetPosY = player.func_226278_cu_() - player.func_70033_W();
        return playerFeetPosY;
    }

    public static int calculatePlayerFeetPosititionAsInt(PlayerEntity player) {
        return (int)PlayerUtils.calculatePlayerFeetPositition(player);
    }

    public static boolean isBelowPlayerYPosition(int y, PlayerEntity player) {
        int playerFeetPosition = PlayerUtils.calculatePlayerFeetPosititionAsInt(player);
        return y < playerFeetPosition;
    }

    public static PlayerDirection getPlayerDirection(PlayerEntity player) {
        int direction = MathHelper.func_76128_c((double)((double)(player.field_70177_z * 4.0f / 360.0f) + 0.5)) & 3;
        return PlayerDirection.getById(direction);
    }

    public static void sendChatMessageToPlayer(PlayerEntity player, String string) {
        StringTextComponent message = new StringTextComponent(string);
        UUID uuid = player.func_110124_au();
        player.func_145747_a((ITextComponent)message, uuid);
    }

    public static boolean hasIdenticalUniqueID(Entity e1, Entity e2) {
        if (e1 == null) {
            return false;
        }
        if (e2 == null) {
            return false;
        }
        return e1.func_110124_au() == e2.func_110124_au();
    }

    public static boolean isTypePlayerEntity(Entity entity) {
        Optional<Entity> oe = Optional.ofNullable(entity);
        if (oe.isPresent()) {
            return oe.get() instanceof PlayerEntity;
        }
        return false;
    }

    public static boolean isPlayerEntityAlive(Entity entity) {
        if (!PlayerUtils.isTypePlayerEntity(entity)) {
            return false;
        }
        PlayerEntity targetAsPlayer = (PlayerEntity)entity;
        return targetAsPlayer.func_70089_S();
    }

    public static boolean isItemHeldInOffHand(PlayerEntity player, ItemStack item) {
        if (player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        ItemStack heldItem = player.func_184592_cb();
        if (heldItem == null) {
            return false;
        }
        return heldItem.equals(item);
    }

    public static boolean isItemHeldInOffHand(PlayerEntity player, Item item) {
        if (player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        ItemStack heldItemStack = player.func_184592_cb();
        if (heldItemStack == null) {
            return false;
        }
        Item heldItem = heldItemStack.func_77973_b();
        if (heldItem == null) {
            return false;
        }
        return item.equals(heldItem);
    }

    public static boolean isItemHeldInMainHand(PlayerEntity player, Item item) {
        if (player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        ItemStack heldItemStack = player.func_184614_ca();
        if (heldItemStack == null) {
            return false;
        }
        Item heldItem = heldItemStack.func_77973_b();
        if (heldItem == null) {
            return false;
        }
        return item.equals(heldItem);
    }

    public static boolean isItemHeldInEitherHands(PlayerEntity player, Item item) {
        if (PlayerUtils.isItemHeldInMainHand(player, item)) {
            return true;
        }
        return PlayerUtils.isItemHeldInOffHand(player, item);
    }

    public static boolean isItemInHotbar(PlayerEntity player, Item item) {
        if (player == null) {
            return false;
        }
        if (item == null) {
            return false;
        }
        for (int i = 0; i < 10; ++i) {
            ItemStack itemStackHotbar = player.field_71071_by.func_70301_a(i);
            Item itemHotBar = itemStackHotbar.func_77973_b();
            if (!itemHotBar.equals(item)) continue;
            return true;
        }
        return false;
    }

    public static Vector3d CalculatePlayerPosition(PlayerEntity player, float partialTicks) {
        double doubleX = player.field_70142_S + (player.func_226277_ct_() - player.field_70142_S) * (double)partialTicks;
        double doubleY = player.field_70137_T + (player.func_226278_cu_() - player.field_70137_T) * (double)partialTicks;
        double doubleZ = player.field_70136_U + (player.func_226281_cx_() - player.field_70136_U) * (double)partialTicks;
        return new Vector3d(doubleX, doubleY, doubleZ);
    }
}

