/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.potion;

import bassebombecraft.config.ConfigUtils;
import bassebombecraft.potion.effect.RegisteredEffects;
import java.util.Optional;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Potion;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.common.brewing.BrewingRecipe;
import net.minecraftforge.common.brewing.BrewingRecipeRegistry;
import net.minecraftforge.common.brewing.IBrewingRecipe;
import net.minecraftforge.fml.RegistryObject;

public class PotionUtils {
    public static Potion getInstance(String name, Effect effect) {
        String configPath = "Potions." + name;
        int duration = ConfigUtils.getInt(configPath + ".duration");
        int amplifier = ConfigUtils.getInt(configPath + ".amplifier");
        EffectInstance effectInstance = new EffectInstance(effect, duration, amplifier);
        return new Potion(new EffectInstance[]{effectInstance});
    }

    public static void registerPotionRecipe(Potion basePotion, Item reagent, RegistryObject<Potion> splPotion) {
        Potion targetPotion = (Potion)splPotion.get();
        Ingredient baseItem = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)basePotion)});
        Ingredient reagantItem = Ingredient.func_193369_a((ItemStack[])new ItemStack[]{new ItemStack((IItemProvider)reagent)});
        ItemStack out = net.minecraft.potion.PotionUtils.func_185188_a((ItemStack)new ItemStack((IItemProvider)Items.field_151068_bn), (Potion)targetPotion);
        BrewingRecipeRegistry.addRecipe((IBrewingRecipe)new BrewingRecipe(baseItem, reagantItem, out));
    }

    public static void registerPotionRecipe(RegistryObject<Potion> splBasePotion, Item reagent, RegistryObject<Potion> splPotion) {
        Potion basePotion = (Potion)splBasePotion.get();
        PotionUtils.registerPotionRecipe(basePotion, reagent, splPotion);
    }

    public static Optional<EffectInstance> getEffectIfActive(LivingEntity entity, Effect effect) {
        if (entity == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(entity.func_70660_b(effect));
    }

    public static boolean isAmplifierEffectActive(LivingEntity entity) {
        Optional<EffectInstance> optEffect = PotionUtils.getEffectIfActive(entity, (Effect)RegisteredEffects.AMPLIFIER_EFFECT.get());
        return optEffect.isPresent();
    }
}

