/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.projectile.action;

import bassebombecraft.BassebombeCraft;
import bassebombecraft.config.ModConfiguration;
import bassebombecraft.entity.EntityUtils;
import bassebombecraft.entity.ai.AiUtils;
import bassebombecraft.player.PlayerUtils;
import bassebombecraft.projectile.action.ProjectileAction;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.passive.CatEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;

public class SpawnKittenArmy
implements ProjectileAction {
    public static final String NAME = SpawnKittenArmy.class.getSimpleName();
    static final int CAT_TYPE = 3;
    static final float PITCH = 0.0f;
    final int age = (Integer)ModConfiguration.spawnKittenArmyAge.get();
    final int kittens = (Integer)ModConfiguration.spawnKittenArmyEntities.get();
    final int spawnSize = (Integer)ModConfiguration.spawnKittenArmySpawnArea.get();
    final List<? extends String> names = (List)ModConfiguration.spawnKittenArmyNames.get();

    @Override
    public void execute(ThrowableEntity projectile, World world, RayTraceResult result) {
        try {
            Entity shooter = projectile.func_234616_v_();
            for (int i = 0; i < this.kittens; ++i) {
                CatEntity entity = (CatEntity)EntityType.field_220360_g.func_200721_a(world);
                if (i == 0) {
                    entity.func_70873_a(1);
                } else {
                    entity.func_70873_a(this.age);
                }
                if (PlayerUtils.isTypePlayerEntity(shooter)) {
                    PlayerEntity player = (PlayerEntity)shooter;
                    entity.func_193101_c(player);
                }
                EntityUtils.setRandomSpawnPosition(projectile.func_233580_cy_(), projectile.field_70177_z, this.spawnSize, (LivingEntity)entity);
                if (EntityUtils.isTypeLivingEntity(shooter)) {
                    BassebombeCraft.getProxy().getServerTeamRepository().add((LivingEntity)shooter, (LivingEntity)entity);
                }
                if (EntityUtils.isTypeLivingEntity(shooter)) {
                    AiUtils.clearAllAiGoals((MobEntity)entity);
                    AiUtils.buildKittenArmyAi(entity, (LivingEntity)shooter);
                }
                Random random = BassebombeCraft.getBassebombeCraft().getRandom();
                StringTextComponent name = new StringTextComponent(this.getKittenName(random, i));
                entity.func_200203_b((ITextComponent)name);
                entity.func_174805_g(true);
                world.func_217376_c((Entity)entity);
            }
        }
        catch (Exception e) {
            BassebombeCraft.getBassebombeCraft().reportAndLogException(e);
        }
    }

    String getKittenName(Random random, int index) {
        if (index == 0) {
            return this.names.get(index);
        }
        int size = this.names.size();
        int randomIndex = random.nextInt(size - 1);
        return this.names.get(randomIndex + 1);
    }
}

