/*
 * Decompiled with CFR 0.152.
 */
package bassebombecraft.world;

import java.util.Optional;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.effect.LightningBoltEntity;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;

public class WorldUtils {
    static final float SOUND_VOLUME = 0.5f;
    static final float SOUND_PITCH = 1.0f;

    public static boolean isLogicalClient(World world) {
        return world.func_201670_d();
    }

    public static boolean isLogicalServer(World world) {
        return !world.func_201670_d();
    }

    public static boolean isLogicalClient(Entity entity) {
        return WorldUtils.isLogicalClient(entity.func_130014_f_());
    }

    public static boolean isLogicalServer(Entity entity) {
        return WorldUtils.isLogicalServer(entity.func_130014_f_());
    }

    public static boolean isTypeServerWorld(World world) {
        Optional<World> ow = Optional.ofNullable(world);
        if (ow.isPresent()) {
            return ow.get() instanceof World;
        }
        return false;
    }

    public static boolean isTypeClientWorld(World world) {
        Optional<World> ow = Optional.ofNullable(world);
        if (ow.isPresent()) {
            return ow.get() instanceof ClientWorld;
        }
        return false;
    }

    public static void addLightningAtBlockPos(World world, BlockPos pos) {
        LightningBoltEntity lightningboltentity = (LightningBoltEntity)EntityType.field_200728_aG.func_200721_a(world);
        lightningboltentity.func_233576_c_(Vector3d.func_237492_c_((Vector3i)pos));
        lightningboltentity.func_233623_a_(false);
        world.func_217376_c((Entity)lightningboltentity);
        lightningboltentity.func_184185_a(SoundEvents.field_187754_de, 0.5f, 1.0f);
    }
}

