/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.impl.conn;

import shadowed.org.apache.http.HttpResponse;
import shadowed.org.apache.http.HttpResponseFactory;
import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.config.MessageConstraints;
import shadowed.org.apache.http.impl.DefaultHttpResponseFactory;
import shadowed.org.apache.http.impl.conn.DefaultHttpResponseParser;
import shadowed.org.apache.http.io.HttpMessageParser;
import shadowed.org.apache.http.io.HttpMessageParserFactory;
import shadowed.org.apache.http.io.SessionInputBuffer;
import shadowed.org.apache.http.message.BasicLineParser;
import shadowed.org.apache.http.message.LineParser;

@Contract(threading=ThreadingBehavior.IMMUTABLE_CONDITIONAL)
public class DefaultHttpResponseParserFactory
implements HttpMessageParserFactory<HttpResponse> {
    public static final DefaultHttpResponseParserFactory INSTANCE = new DefaultHttpResponseParserFactory();
    private final LineParser lineParser;
    private final HttpResponseFactory responseFactory;

    public DefaultHttpResponseParserFactory(LineParser lineParser, HttpResponseFactory responseFactory) {
        this.lineParser = lineParser != null ? lineParser : BasicLineParser.INSTANCE;
        this.responseFactory = responseFactory != null ? responseFactory : DefaultHttpResponseFactory.INSTANCE;
    }

    public DefaultHttpResponseParserFactory(HttpResponseFactory responseFactory) {
        this(null, responseFactory);
    }

    public DefaultHttpResponseParserFactory() {
        this(null, null);
    }

    @Override
    public HttpMessageParser<HttpResponse> create(SessionInputBuffer buffer, MessageConstraints constraints) {
        return new DefaultHttpResponseParser(buffer, this.lineParser, this.responseFactory, constraints);
    }
}

