/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.impl.cookie;

import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.cookie.CommonCookieAttributeHandler;
import shadowed.org.apache.http.cookie.Cookie;
import shadowed.org.apache.http.cookie.CookieOrigin;
import shadowed.org.apache.http.cookie.MalformedCookieException;
import shadowed.org.apache.http.cookie.SetCookie;
import shadowed.org.apache.http.impl.cookie.AbstractCookieAttributeHandler;
import shadowed.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class BasicSecureHandler
extends AbstractCookieAttributeHandler
implements CommonCookieAttributeHandler {
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        Args.notNull(cookie, "Cookie");
        cookie.setSecure(true);
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull(cookie, "Cookie");
        Args.notNull(origin, "Cookie origin");
        return !cookie.isSecure() || origin.isSecure();
    }

    @Override
    public String getAttributeName() {
        return "secure";
    }
}

