/*
 * Decompiled with CFR 0.152.
 */
package shadowed.org.apache.http.protocol;

import java.io.IOException;
import shadowed.org.apache.http.HttpException;
import shadowed.org.apache.http.HttpRequest;
import shadowed.org.apache.http.HttpRequestInterceptor;
import shadowed.org.apache.http.annotation.Contract;
import shadowed.org.apache.http.annotation.ThreadingBehavior;
import shadowed.org.apache.http.protocol.HttpContext;
import shadowed.org.apache.http.util.Args;

@Contract(threading=ThreadingBehavior.IMMUTABLE)
public class RequestConnControl
implements HttpRequestInterceptor {
    @Override
    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        Args.notNull(request, "HTTP request");
        String method = request.getRequestLine().getMethod();
        if (method.equalsIgnoreCase("CONNECT")) {
            return;
        }
        if (!request.containsHeader("Connection")) {
            request.addHeader("Connection", "Keep-Alive");
        }
    }
}

