/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib;

import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.platform.Platform;
import dev.architectury.registry.registries.Registrar;
import dev.architectury.registry.registries.Registries;
import dev.itsmeow.betteranimalmodels.imdlib.entity.EntityRegistrarHandler;
import dev.itsmeow.betteranimalmodels.imdlib.fabric.IMDLibImpl;
import java.util.Optional;
import net.minecraft.class_2378;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class IMDLib {
    private static Optional<Registries> REGISTRIES = Optional.empty();
    private static MinecraftServer SERVER;

    public static Optional<Registries> getRegistries() {
        return REGISTRIES;
    }

    public static <T> Registrar<T> getRegistry(class_5321<class_2378<T>> key) {
        if (!IMDLib.getRegistries().isPresent()) {
            throw new RuntimeException("Registries have not been initialized yet! Call IMDLib.setRegistry(modid) or use IMDLib.entityHandler(modid)");
        }
        return IMDLib.getRegistries().get().get(key);
    }

    public static void setRegistry(String modid) {
        REGISTRIES = Optional.of(Registries.get((String)modid));
    }

    public static void setStaticServerInstance(MinecraftServer server) {
        SERVER = server;
    }

    public static MinecraftServer getStaticServerInstance() {
        if (SERVER == null) {
            MinecraftServer server;
            if (Platform.isForge() && (server = IMDLib.getForgeServer()) != null) {
                SERVER = server;
                return server;
            }
            throw new RuntimeException("Server not initialized yet! Call IMDLib.setStaticServerInstance(server) or use IMDLib.entityHandler(modid)");
        }
        return SERVER;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static MinecraftServer getForgeServer() {
        return IMDLibImpl.getForgeServer();
    }

    public static EntityRegistrarHandler entityHandler(String modid) {
        IMDLib.setRegistry(modid);
        return new EntityRegistrarHandler(modid);
    }
}

