/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.compat.modmenu;

import com.terraformersmc.modmenu.api.ConfigScreenFactory;
import com.terraformersmc.modmenu.api.ModMenuApi;
import dev.itsmeow.betteranimalmodels.imdlib.mixin.ClothConfigScreenAccessor;
import dev.itsmeow.betteranimalmodels.imdlib.util.SafePlatform;
import dev.itsmeow.betteranimalmodels.imdlib.util.config.CommonFabricConfigContainer;
import dev.itsmeow.betteranimalmodels.imdlib.util.config.FabricConfigContainer;
import dev.itsmeow.betteranimalmodels.imdlib.util.config.ServerFabricConfigContainer;
import io.github.fablabsmc.fablabs.api.fiber.v1.builder.ConfigTreeBuilder;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.ValueDeserializationException;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigTree;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.function.Supplier;
import me.shedaniel.clothconfig2.gui.ClothConfigScreen;
import me.shedaniel.clothconfig2.gui.ClothConfigTabButton;
import me.shedaniel.fiber2cloth.api.Fiber2Cloth;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2561;
import net.minecraft.class_2585;
import net.minecraft.class_2588;
import net.minecraft.class_310;
import net.minecraft.class_32;
import net.minecraft.class_33;
import net.minecraft.class_34;
import net.minecraft.class_437;

public class ModMenuCompat
implements ModMenuApi {
    public ConfigScreenFactory<?> getModConfigScreenFactory() {
        Supplier<Supplier> supplier = () -> () -> new ClothConfigScreenFactory(SafePlatform.modId());
        return SafePlatform.isModLoaded("cloth-config2") ? (ConfigScreenFactory)supplier.get().get() : screen -> null;
    }

    public static class ClothConfigScreenFactory
    implements ConfigScreenFactory<class_437> {
        private final String modId;

        public ClothConfigScreenFactory(String modId) {
            this.modId = modId;
        }

        public class_437 create(class_437 parent) {
            ConfigTreeBuilder b = ConfigTree.builder();
            for (FabricConfigContainer c : CommonFabricConfigContainer.INSTANCES) {
                c.getBranch().detach();
                b.withChild(c.getBranch());
            }
            HashMap<File, ServerFabricConfigContainer> serverConfigs = new HashMap<File, ServerFabricConfigContainer>();
            File defaultConfig = new File(FabricLoader.getInstance().getGameDir().resolve("defaultconfigs").toFile(), ServerFabricConfigContainer.INSTANCE.getConfigName() + ".json5");
            if (defaultConfig.exists()) {
                ServerFabricConfigContainer c = new ServerFabricConfigContainer();
                try {
                    c.loadFromFile(defaultConfig);
                }
                catch (ValueDeserializationException | IOException exception) {
                    // empty catch block
                }
                c.getBranch().detach();
                b.withChild(c.getBranch());
                serverConfigs.put(defaultConfig, c);
            }
            try {
                class_32 levelSource = class_310.method_1551().method_1586();
                for (class_34 level : levelSource.method_235()) {
                    File config = levelSource.method_19636().resolve(level.method_248()).resolve("serverconfig/" + ServerFabricConfigContainer.INSTANCE.getConfigName() + ".json5").toFile();
                    if (!config.exists()) continue;
                    ServerFabricConfigContainer c = new ServerFabricConfigContainer(level.method_248());
                    try {
                        c.loadFromFile(config);
                    }
                    catch (ValueDeserializationException | IOException e) {
                        continue;
                    }
                    c.getBranch().detach();
                    b.withChild(c.getBranch());
                    serverConfigs.put(config, c);
                }
            }
            catch (class_33 levelSource) {
                // empty catch block
            }
            Fiber2Cloth fiber2Cloth = Fiber2Cloth.create(parent, this.modId, b.build(), this.modId).setTitleText((class_2561)new class_2588("config." + this.modId)).setSaveRunnable(() -> {
                for (FabricConfigContainer c : CommonFabricConfigContainer.INSTANCES) {
                    c.saveBranch(c.getConfigFile(null), b.lookupBranch(c.getConfigName()));
                }
                for (File file : serverConfigs.keySet()) {
                    ServerFabricConfigContainer c = (ServerFabricConfigContainer)serverConfigs.get(file);
                    c.saveBranch(file, b.lookupBranch(c.getConfigName()));
                }
            });
            class_437 screen = fiber2Cloth.setAfterInitConsumer(initialized -> {
                if (initialized instanceof ClothConfigScreen) {
                    ClothConfigScreen s = (ClothConfigScreen)initialized;
                    List<ClothConfigTabButton> buttons = ((ClothConfigScreenAccessor)s).getTabButtons();
                    for (ClothConfigTabButton btn : buttons) {
                        if (!btn.method_25369().getString().matches("config\\." + this.modId + "\\.[\\S\\s]+?-" + this.modId + "-server$")) continue;
                        String saveName = btn.method_25369().getString().substring(("config." + this.modId + ".").length(), btn.method_25369().getString().length() - ("-" + this.modId + "-server").length());
                        String newText = "World: " + saveName;
                        btn.method_25355((class_2561)new class_2585(newText));
                        btn.method_25358(class_310.method_1551().field_1772.method_1727(newText) + 8);
                    }
                }
            }).build().getScreen();
            return screen;
        }
    }
}

