/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.entity;

import com.google.common.collect.ImmutableList;
import dev.architectury.registry.registries.RegistrySupplier;
import dev.itsmeow.betteranimalmodels.imdlib.IMDLib;
import dev.itsmeow.betteranimalmodels.imdlib.entity.AbstractEntityBuilder;
import dev.itsmeow.betteranimalmodels.imdlib.entity.EntityTypeDefinition;
import dev.itsmeow.betteranimalmodels.imdlib.entity.interfaces.ISelectiveVariantTypes;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.builder.IEntityTypeDefinition;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.variant.EntityVariantList;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.variant.IVariant;
import dev.itsmeow.betteranimalmodels.imdlib.item.ModSpawnEggItem;
import dev.itsmeow.betteranimalmodels.imdlib.mixin.SpawnPlacementsInvoker;
import dev.itsmeow.betteranimalmodels.imdlib.util.HeadType;
import dev.itsmeow.betteranimalmodels.imdlib.util.config.ConfigBuilder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1311;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_3612;
import net.minecraft.class_3730;
import net.minecraft.class_5132;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5483;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class EntityTypeContainer<T extends class_1308> {
    protected final IEntityTypeDefinition<T> definition;
    public boolean despawn;
    public Supplier<Set<class_5321<class_1959>>> spawnBiomesSupplier;
    public EntityConfiguration config;
    protected EntityVariantList variantList;
    protected class_2940<String> variantDataKey;
    protected boolean placementRegistered = false;
    protected Set<class_5321<class_1959>> spawnBiomesCache = null;
    protected Supplier<Set<class_5321<class_1959>>> spawnCostBiomesSupplier;
    protected Set<class_5321<class_1959>> spawnCostBiomesCache = null;
    protected HeadType headType;
    protected RegistrySupplier<ModSpawnEggItem> egg;
    protected class_1299<T> entityType;
    protected final CustomConfigurationHolder<T> customConfigHolder = new CustomConfigurationHolder(this);
    protected final CustomConfigurationHolder<T> customConfigHolderClient = new CustomConfigurationHolder(this);
    protected final class_3528<class_5483.class_1964> spawnEntry = new class_3528(() -> new class_5483.class_1964(this.entityType, this.config.spawnWeight.get().intValue(), this.config.spawnMinGroup.get().intValue(), this.config.spawnMaxGroup.get().intValue()));

    public EntityTypeContainer(IEntityTypeDefinition<T> def) {
        this.definition = def;
        if (this.hasVariants()) {
            this.variantList = new EntityVariantList(def.getVariantAmount());
            this.variantList.add(def.getVariants());
        }
        this.spawnBiomesSupplier = def.getDefaultSpawnBiomes() != null ? def.getDefaultSpawnBiomes() : HashSet::new;
        this.spawnCostBiomesSupplier = this.spawnBiomesSupplier;
    }

    public static <T extends class_1308> boolean waterSpawn(class_1299<T> type, class_5425 world, class_3730 reason, class_2338 pos, Random rand) {
        return pos.method_10264() > 45 && pos.method_10264() < world.method_8615() - 1 && world.method_8316(pos).method_15772() == class_3612.field_15910;
    }

    public static List<String> setBiomesToIDs(Set<class_5321<class_1959>> set) {
        return set.parallelStream().filter(Objects::nonNull).map(biomeResourceKey -> biomeResourceKey.method_29177().toString()).collect(Collectors.toList());
    }

    public IEntityTypeDefinition<T> getDefinition() {
        return this.definition;
    }

    public class_1299<T> getEntityType() {
        return this.entityType;
    }

    public EntityConfiguration getConfiguration() {
        return this.config;
    }

    public String getModId() {
        return this.definition.getModId();
    }

    public boolean hasEgg() {
        return this.definition.hasEgg();
    }

    public boolean hasSpawns() {
        return this.definition.hasSpawns();
    }

    public float getWidth() {
        return this.definition.getWidth();
    }

    public float getHeight() {
        return this.definition.getHeight();
    }

    public Class<T> getEntityClass() {
        return this.definition.getEntityClass();
    }

    public String getEntityName() {
        return this.definition.getEntityName();
    }

    public Supplier<class_5132.class_5133> getAttributeBuilder() {
        return this.definition.getAttributeMap();
    }

    public HeadType getHeadType() {
        return this.headType;
    }

    public CustomConfigurationHolder<T> getCustomConfiguration() {
        return this.customConfigHolder;
    }

    public CustomConfigurationHolder<T> getCustomConfigurationClient() {
        return this.customConfigHolderClient;
    }

    void setHeadType(HeadType headType) {
        this.headType = headType;
    }

    public boolean hasVariants() {
        return this.definition.getVariantAmount() > 0;
    }

    public int getVariantMax() {
        return this.definition.getVariantAmount();
    }

    public class_5483.class_1964 getSpawnEntry() {
        return (class_5483.class_1964)this.spawnEntry.method_15332();
    }

    public boolean despawns() {
        return this.despawn;
    }

    public RegistrySupplier<ModSpawnEggItem> getEggItem() {
        return this.egg;
    }

    void registerPlacement() {
        if (this.definition.getPlacementType() != null && this.definition.getPlacementPredicate() != null && this.definition.getPlacementHeightMapType() != null && !this.placementRegistered) {
            SpawnPlacementsInvoker.invokeRegister(this.entityType, this.definition.getPlacementType(), this.definition.getPlacementHeightMapType(), this.definition.getPlacementPredicate());
            this.placementRegistered = true;
        }
    }

    protected void createConfiguration(ConfigBuilder builder) {
        this.config = new EntityConfiguration(builder);
    }

    protected void customConfigurationLoad() {
        if (this.definition.getCustomConfigLoad() != null) {
            this.definition.getCustomConfigLoad().load(this.customConfigHolder);
        }
    }

    protected void clientCustomConfigurationLoad() {
        if (this.definition.getCustomClientConfigLoad() != null) {
            this.definition.getCustomClientConfigLoad().load(this.customConfigHolderClient);
        }
    }

    protected void customConfigurationInit(ConfigBuilder builder) {
        if (this.definition.getCustomConfigInit() != null) {
            this.definition.getCustomConfigInit().init(this.customConfigHolder, builder);
        }
    }

    protected void clientCustomConfigurationInit(ConfigBuilder builder) {
        if (this.definition.getCustomClientConfigInit() != null) {
            builder.push(this.getEntityName());
            this.definition.getCustomClientConfigInit().init(this.customConfigHolderClient, builder);
            builder.pop();
        }
    }

    public void onCreateEntityType() {
    }

    public List<String> getBiomeIDs() {
        return EntityTypeContainer.setBiomesToIDs(this.getSpawnBiomes());
    }

    public List<String> getSpawnCostBiomeIDs() {
        return EntityTypeContainer.setBiomesToIDs(this.getSpawnCostBiomes());
    }

    public Set<class_5321<class_1959>> getSpawnBiomes() {
        if (this.spawnBiomesCache == null) {
            this.spawnBiomesCache = this.spawnBiomesSupplier.get();
        }
        return this.spawnBiomesCache;
    }

    public Set<class_5321<class_1959>> getSpawnCostBiomes() {
        if (this.spawnCostBiomesCache == null) {
            this.spawnCostBiomesCache = this.spawnCostBiomesSupplier.get();
        }
        return this.spawnCostBiomesCache;
    }

    public void setSpawnBiomesSupplier(Supplier<Set<class_5321<class_1959>>> biomesSupplier) {
        this.spawnBiomesCache = null;
        this.spawnBiomesSupplier = biomesSupplier;
    }

    public void setSpawnCostBiomesSupplier(Supplier<Set<class_5321<class_1959>>> biomesSupplier) {
        this.spawnCostBiomesCache = null;
        this.spawnCostBiomesSupplier = biomesSupplier;
    }

    public Optional<IVariant> getVariantForName(String name) {
        return this.variantList.getVariantForName(name);
    }

    @Deprecated
    public Optional<IVariant> getVariantForIndex(int index) {
        return this.variantList.getVariantForIndex(index);
    }

    public ImmutableList<IVariant> getVariants() {
        return this.variantList.getVariantList();
    }

    @Deprecated
    public int getVariantIndex(IVariant variant) {
        return this.variantList.getVariantIndex(variant);
    }

    public class_2940<String> getVariantDataKey() {
        if (this.variantDataKey == null) {
            this.variantDataKey = class_2945.method_12791(this.getEntityClass(), (class_2941)class_2943.field_13326);
        }
        return this.variantDataKey;
    }

    public static class CustomConfigurationHolder<T extends class_1308> {
        protected Map<String, Pair<Class<?>, Supplier<?>>> values = new HashMap();
        protected EntityTypeContainer<T> container;

        CustomConfigurationHolder(EntityTypeContainer<T> container) {
            this.container = container;
        }

        public int getInt(String path) {
            return this.getIntHolder(path).get();
        }

        public String getString(String path) {
            return this.getStringHolder(path).get();
        }

        public double getDouble(String path) {
            return this.getDoubleHolder(path).get();
        }

        public long getLong(String path) {
            return this.getLongHolder(path).get();
        }

        public boolean getBoolean(String path) {
            return this.getBooleanHolder(path).get();
        }

        public <V> Supplier<V> getAnyHolder(Class<? extends V> clazz, String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(clazz) ? () -> clazz.cast(((Supplier)v.getRight()).get()) : null;
        }

        public Supplier<Integer> getIntHolder(String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(Integer.class) ? () -> (Integer)((Supplier)v.getRight()).get() : null;
        }

        public Supplier<String> getStringHolder(String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(String.class) ? () -> (String)((Supplier)v.getRight()).get() : null;
        }

        public Supplier<Double> getDoubleHolder(String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(Double.class) ? () -> (Double)((Supplier)v.getRight()).get() : null;
        }

        public Supplier<Long> getLongHolder(String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(Long.class) ? () -> (Long)((Supplier)v.getRight()).get() : null;
        }

        public Supplier<Boolean> getBooleanHolder(String path) {
            Pair<Class<?>, Supplier<?>> v = this.values.get(path);
            return ((Class)v.getLeft()).isAssignableFrom(Boolean.class) ? () -> (Boolean)((Supplier)v.getRight()).get() : null;
        }

        public void put(String path, Class<?> type, Supplier<?> value) {
            this.values.put(path, Pair.of(type, value));
        }
    }

    public class EntityConfiguration {
        public Supplier<Boolean> doSpawning;
        public Supplier<Boolean> biomeVariants;
        public Supplier<Integer> spawnMinGroup;
        public Supplier<Integer> spawnMaxGroup;
        public Supplier<Integer> spawnWeight;
        public Supplier<Boolean> useSpawnCosts;
        public Supplier<Double> spawnCostPer;
        public Supplier<Double> spawnMaxCost;
        public Supplier<List<? extends String>> biomesList;
        public Supplier<List<? extends String>> spawnCostBiomes;
        public Supplier<Boolean> doDespawn;

        protected EntityConfiguration(ConfigBuilder builder) {
            EntityTypeContainer container = EntityTypeContainer.this;
            builder.push(container.getEntityName());
            if (EntityTypeContainer.this.definition.getSpawnClassification() == class_1311.field_6294) {
                this.doDespawn = builder.define("can_despawn", "Allows the entity to despawn freely when no players are nearby, like vanilla monsters do", EntityTypeContainer.this.definition.despawns());
            }
            if (EntityTypeContainer.this.hasSpawns()) {
                builder.push("spawning");
                this.doSpawning = builder.define("spawn_naturally", "Enables natural spawning - More info on these options: https://minecraft.fandom.com/wiki/Spawn#Java_Edition", true);
                this.spawnWeight = builder.defineInRange("spawn_weight", "The spawn weight compared to other entities (typically between 6-20)", EntityTypeContainer.this.definition.getSpawnWeight(), 1, 9999);
                this.spawnMinGroup = builder.defineInRange("minimum_group_size", "Minimum amount of entities in spawned groups", EntityTypeContainer.this.definition.getSpawnMinGroup(), 1, 9999);
                this.spawnMaxGroup = builder.defineInRange("maximum_group_size", "Maximum amount of entities in spawned groups - Must be greater or equal to min value", EntityTypeContainer.this.definition.getSpawnMaxGroup(), 1, 9999);
                this.biomesList = builder.defineList("spawn_biomes", "Enter biome IDs. Supports modded biomes https://minecraft.fandom.com/wiki/Biome#Biome_IDs", () -> EntityTypeContainer.setBiomesToIDs(EntityTypeContainer.this.definition.getDefaultSpawnBiomes().get()), "", input -> input instanceof String);
                if (ISelectiveVariantTypes.class.isAssignableFrom(EntityTypeContainer.this.getEntityClass())) {
                    this.biomeVariants = builder.define("biome_based_variants", "Enables biome based variant selection. This will make this entity choose variants tailored to the biome they spawn in (Only applies to natural spawns)", true);
                }
                builder.push("spawn_costs");
                this.useSpawnCosts = builder.define("use_spawn_costs", "Whether to use spawn costs in spawning or not", EntityTypeContainer.this.definition.useSpawnCosts());
                this.spawnCostPer = builder.defineInRange("cost_per_spawn", "Cost to spawning algorithm per entity spawned", EntityTypeContainer.this.definition.getSpawnCostPer(), Double.MIN_VALUE, Double.MAX_VALUE);
                this.spawnMaxCost = builder.defineInRange("maximum_cost_per_biome", "Maximum cost the spawning algorithm can accrue for this entity", EntityTypeContainer.this.definition.getSpawnMaxCost(), Double.MIN_VALUE, Double.MAX_VALUE);
                this.spawnCostBiomes = builder.defineList("spawn_cost_biomes", "Enter biome IDs to use these costs in. Supports modded biomes. An empty list will use spawn_biomes https://minecraft.fandom.com/wiki/Biome#Biome_IDs", new ArrayList(), "", input -> input instanceof String);
                builder.pop();
                builder.pop();
            }
            EntityTypeContainer.this.customConfigurationInit(builder);
            builder.pop();
        }

        protected void load() {
            if (EntityTypeContainer.this.hasSpawns()) {
                EntityTypeContainer.this.despawn = EntityTypeContainer.this.definition.getSpawnClassification() == class_1311.field_6294 ? this.doDespawn.get().booleanValue() : EntityTypeContainer.this.definition.despawns();
                Function<Supplier, Set> biomesLoader = configList -> {
                    HashSet<class_5321> biomeKeys = new HashSet<class_5321>();
                    for (String biomeName : (List)configList.get()) {
                        class_2960 rl = new class_2960(biomeName);
                        try {
                            class_2378 reg = IMDLib.getStaticServerInstance().method_30611().method_30530(class_2378.field_25114);
                            class_1959 biome = (class_1959)reg.method_10223(rl);
                            if (biome == null) {
                                LogManager.getLogger().error("Invalid biome \"" + biomeName + "\" for entity " + EntityTypeContainer.this.getEntityName() + ". No biome exists with that name. Skipping.");
                                continue;
                            }
                            biomeKeys.add(class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)rl));
                        }
                        catch (Exception e) {
                            LogManager.getLogger().error("Invalid biome name: \"" + biomeName + "\" for entity " + EntityTypeContainer.this.getEntityName() + ". Is it formatted correctly? Skipping.");
                        }
                    }
                    return biomeKeys;
                };
                EntityTypeContainer.this.setSpawnBiomesSupplier(() -> (Set)biomesLoader.apply(this.biomesList));
                if (this.useSpawnCosts.get().booleanValue()) {
                    EntityTypeContainer.this.setSpawnCostBiomesSupplier(this.spawnCostBiomes.get().size() == 0 ? EntityTypeContainer.this.spawnBiomesSupplier : () -> (Set)biomesLoader.apply(this.spawnCostBiomes));
                }
            }
            EntityTypeContainer.this.customConfigurationLoad();
        }
    }

    @FunctionalInterface
    public static interface CustomConfigurationLoad {
        public void load(CustomConfigurationHolder<?> var1);
    }

    @FunctionalInterface
    public static interface CustomConfigurationInit {
        public void init(CustomConfigurationHolder<?> var1, ConfigBuilder var2);
    }

    public static class Builder<T extends class_1308>
    extends AbstractEntityBuilder<T, EntityTypeContainer<T>, Builder<T>> {
        private Builder(Class<T> EntityClass, class_1299.class_4049<T> factory, String entityNameIn, Supplier<class_5132.class_5133> attributeMap, String modid) {
            super(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        public static <T extends class_1308> Builder<T> create(Class<T> EntityClass, class_1299.class_4049<T> factory, String entityNameIn, Supplier<class_5132.class_5133> attributeMap, String modid) {
            return new Builder<T>(EntityClass, factory, entityNameIn, attributeMap, modid);
        }

        @Override
        public EntityTypeContainer<T> rawBuild() {
            return new EntityTypeContainer(new EntityTypeDefinition(this));
        }

        @Override
        public Builder<T> getImplementation() {
            return this;
        }
    }
}

