/*
 * Decompiled with CFR 0.152.
 */
package io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived;

import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.DecimalSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.EnumSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.ListSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.MapSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.StringSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.BooleanConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ListConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.MapConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.NumberConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.StringConfigType;
import io.github.fablabsmc.fablabs.impl.fiber.annotation.magic.TypeMagic;
import java.lang.reflect.Array;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;

public final class ConfigTypes {
    public static final BooleanConfigType<Boolean> BOOLEAN = new BooleanConfigType<Boolean>(Boolean.class, Function.identity(), Function.identity());
    public static final NumberConfigType<BigDecimal> UNBOUNDED_DECIMAL = ConfigTypes.makeNumber(BigDecimal.class, Function.identity(), Function.identity(), null, null, null);
    public static final NumberConfigType<BigInteger> UNBOUNDED_INTEGER = ConfigTypes.makeNumber(BigInteger.class, BigDecimal::new, BigDecimal::toBigInteger, null, null, null);
    public static final NumberConfigType<Byte> BYTE = ConfigTypes.makeNumber(Byte.class, BigDecimal::valueOf, Number::byteValue, (byte)-128, (byte)127, (byte)1);
    public static final NumberConfigType<Short> SHORT = ConfigTypes.makeNumber(Short.class, BigDecimal::valueOf, Number::shortValue, (short)Short.MIN_VALUE, (short)Short.MAX_VALUE, (short)1);
    public static final NumberConfigType<Integer> INTEGER = ConfigTypes.makeNumber(Integer.class, BigDecimal::valueOf, BigDecimal::intValue, Integer.MIN_VALUE, Integer.MAX_VALUE, 1);
    public static final NumberConfigType<Long> LONG = ConfigTypes.makeNumber(Long.class, BigDecimal::valueOf, BigDecimal::longValue, Long.MIN_VALUE, Long.MAX_VALUE, 1L);
    public static final NumberConfigType<Float> FLOAT = ConfigTypes.makeNumber(Float.class, BigDecimal::valueOf, BigDecimal::floatValue, null, null, null);
    public static final NumberConfigType<Double> DOUBLE = ConfigTypes.makeNumber(Double.class, BigDecimal::valueOf, BigDecimal::doubleValue, null, null, null);
    public static final NumberConfigType<Integer> NATURAL = INTEGER.withMinimum(0);
    public static final StringConfigType<String> STRING = new StringConfigType<String>(StringSerializableType.DEFAULT_STRING, String.class, Function.identity(), Function.identity());
    public static final StringConfigType<Character> CHARACTER = STRING.withMinLength(1).withMaxLength(1).derive(Character.class, s -> Character.valueOf(s.charAt(0)), Object::toString);

    public static <N> NumberConfigType<N> makeNumber(Class<N> numberType, Function<N, BigDecimal> serializer, Function<BigDecimal, N> deserializer, @Nullable N minValue, @Nullable N maxValue, @Nullable N precision) {
        if (minValue == null && precision != null) {
            throw new NullPointerException("A nonnull precision requires a minimum value");
        }
        return new NumberConfigType<N>(new DecimalSerializableType(minValue == null ? null : serializer.apply(minValue), maxValue == null ? null : serializer.apply(maxValue), precision == null ? null : serializer.apply(precision)), numberType, deserializer, serializer);
    }

    public static <E extends Enum<E>> EnumConfigType<E> makeEnum(Class<E> enumType) {
        if (!enumType.isEnum()) {
            throw new IllegalArgumentException(enumType + " is not an enum declaration");
        }
        Set validValues = Arrays.stream(enumType.getEnumConstants()).map(Enum::name).collect(Collectors.toCollection(LinkedHashSet::new));
        return new EnumConfigType<Enum>(new EnumSerializableType(validValues), enumType, e -> Enum.valueOf(enumType, e), Enum::name);
    }

    public static <E, S> ListConfigType<List<E>, S> makeList(ConfigType<E, S, ?> elementType) {
        return new ListConfigType(new ListSerializableType(elementType.getSerializedType()), List.class, l -> {
            ArrayList ret = new ArrayList();
            for (Object s : l) {
                ret.add(elementType.toRuntimeType(s));
            }
            return Collections.unmodifiableList(ret);
        }, l -> {
            ArrayList ret = new ArrayList();
            for (Object e : l) {
                ret.add(elementType.toPlatformType(e));
            }
            return Collections.unmodifiableList(ret);
        });
    }

    public static <E, S> ListConfigType<Set<E>, S> makeSet(ConfigType<E, S, ?> elementType) {
        return new ListConfigType(new ListSerializableType(elementType.getSerializedType(), 0, Integer.MAX_VALUE, true), Set.class, l -> {
            LinkedHashSet ret = new LinkedHashSet();
            for (Object s : l) {
                ret.add(elementType.toRuntimeType(s));
            }
            return Collections.unmodifiableSet(ret);
        }, l -> {
            ArrayList ret = new ArrayList();
            for (Object e : l) {
                ret.add(elementType.toPlatformType(e));
            }
            return Collections.unmodifiableList(ret);
        });
    }

    public static <S> ListConfigType<boolean[], S> makeBooleanArray(ConfigType<Boolean, S, ?> elementType) {
        return ConfigTypes.makeArray(boolean[].class, elementType);
    }

    public static <S> ListConfigType<byte[], S> makeByteArray(ConfigType<Byte, S, ?> elementType) {
        return ConfigTypes.makeArray(byte[].class, elementType);
    }

    public static <S> ListConfigType<short[], S> makeShortArray(ConfigType<Short, S, ?> elementType) {
        return ConfigTypes.makeArray(short[].class, elementType);
    }

    public static <S> ListConfigType<int[], S> makeIntArray(ConfigType<Integer, S, ?> elementType) {
        return ConfigTypes.makeArray(int[].class, elementType);
    }

    public static <S> ListConfigType<long[], S> makeLongArray(ConfigType<Long, S, ?> elementType) {
        return ConfigTypes.makeArray(long[].class, elementType);
    }

    public static <S> ListConfigType<float[], S> makeFloatArray(ConfigType<Float, S, ?> elementType) {
        return ConfigTypes.makeArray(float[].class, elementType);
    }

    public static <S> ListConfigType<double[], S> makeDoubleArray(ConfigType<Double, S, ?> elementType) {
        return ConfigTypes.makeArray(double[].class, elementType);
    }

    public static <S> ListConfigType<char[], S> makeCharArray(ConfigType<Character, S, ?> elementType) {
        return ConfigTypes.makeArray(char[].class, elementType);
    }

    public static <S, E> ListConfigType<E[], S> makeArray(ConfigType<E, S, ?> elementType) {
        Class<E> componentType = TypeMagic.wrapPrimitive(elementType.getRuntimeType());
        Class<?> arrayType = Array.newInstance(componentType, 0).getClass();
        return ConfigTypes.makeArray(arrayType, elementType);
    }

    private static <E, S, A> ListConfigType<A, S> makeArray(Class<A> arrayType, ConfigType<E, S, ?> elementType) {
        Class<?> componentType = arrayType.getComponentType();
        Class<?> boxedComponentType = TypeMagic.wrapPrimitive(componentType);
        assert (boxedComponentType == TypeMagic.wrapPrimitive(elementType.getRuntimeType())) : "Array component type does not match element type modulo boxing";
        return new ListConfigType(new ListSerializableType(elementType.getSerializedType()), arrayType, l -> {
            Object arr = arrayType.cast(Array.newInstance(componentType, l.size()));
            for (int i = 0; i < Array.getLength(arr); ++i) {
                Array.set(arr, i, elementType.toRuntimeType(l.get(i)));
            }
            return arr;
        }, arr -> {
            ArrayList ret = new ArrayList(Array.getLength(arr));
            for (int i = 0; i < Array.getLength(arr); ++i) {
                Object e = boxedComponentType.cast(Array.get(arr, i));
                ret.add(elementType.toPlatformType(e));
            }
            return Collections.unmodifiableList(ret);
        });
    }

    public static <K, V, S> MapConfigType<Map<K, V>, S> makeMap(StringConfigType<K> keyType, ConfigType<V, S, ?> valueType) {
        return new MapConfigType(new MapSerializableType((StringSerializableType)keyType.getSerializedType(), valueType.getSerializedType()), Map.class, map -> {
            LinkedHashMap ret = new LinkedHashMap();
            map.forEach((k, v) -> ret.put(keyType.toRuntimeType(k), valueType.toRuntimeType(v)));
            return Collections.unmodifiableMap(ret);
        }, map -> {
            LinkedHashMap ret = new LinkedHashMap();
            map.forEach((k, v) -> ret.put(keyType.toPlatformType(k), valueType.toPlatformType(v)));
            return ret;
        });
    }
}

