/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.entity.util;

import com.google.common.collect.Lists;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.itsmeow.betteranimalmodels.imdlib.IMDLib;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.forge.BiomeTypesImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.biome.Biome;

public class BiomeTypes {
    public static Type HOT;
    public static Type COLD;
    public static Type SPARSE;
    public static Type DENSE;
    public static Type WET;
    public static Type DRY;
    public static Type SAVANNA;
    public static Type CONIFEROUS;
    public static Type JUNGLE;
    public static Type SPOOKY;
    public static Type DEAD;
    public static Type LUSH;
    public static Type MUSHROOM;
    public static Type MAGICAL;
    public static Type RARE;
    public static Type PLATEAU;
    public static Type MODIFIED;
    public static Type OCEAN;
    public static Type RIVER;
    public static Type WATER;
    public static Type MESA;
    public static Type FOREST;
    public static Type PLAINS;
    public static Type MOUNTAIN;
    public static Type HILL;
    public static Type SWAMP;
    public static Type SANDY;
    public static Type SNOWY;
    public static Type WASTELAND;
    public static Type BEACH;
    public static Type VOID;
    public static Type OVERWORLD;
    public static Type NETHER;
    public static Type END;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        BiomeTypesImpl.init();
    }

    public static Set<Type> getTypes(BiomeModifications.BiomeContext ctx) {
        return Type.TYPES.stream().filter(t -> t.hasType(ctx)).collect(Collectors.toSet());
    }

    public static Set<Type> getTypes(ResourceKey<Biome> biome) {
        return Type.TYPES.stream().filter(t -> t.hasType(biome)).collect(Collectors.toSet());
    }

    public static Set<ResourceKey<Biome>> getBiomes(Type type) {
        Registry reg = null;
        try {
            reg = IMDLib.getStaticServerInstance().m_129911_().m_175515_(Registry.f_122885_);
        }
        catch (RuntimeException e) {
            return new HashSet<ResourceKey<Biome>>();
        }
        Set<ResourceKey<Biome>> res = reg.m_123024_().map(arg_0 -> ((Registry)reg).m_7854_(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(type::hasType).collect(Collectors.toSet());
        return res;
    }

    static {
        BiomeTypes.init();
    }

    public static class Type {
        protected static Set<Type> TYPES = new HashSet<Type>();
        private final Predicate<ResourceKey<Biome>> validator;
        private final Predicate<BiomeModifications.BiomeContext> ctxValidator;
        private final Map<ResourceKey<Biome>, Boolean> validations = new HashMap<ResourceKey<Biome>, Boolean>();
        private final Set<ResourceKey<Biome>> DEFAULTS = new HashSet<ResourceKey<Biome>>();

        public Type(Predicate<ResourceKey<Biome>> validator, Predicate<BiomeModifications.BiomeContext> ctxValidator) {
            this.validator = validator;
            this.ctxValidator = ctxValidator;
            TYPES.add(this);
        }

        public Type addDefaults(ResourceKey<Biome> ... biomes) {
            this.DEFAULTS.addAll(Lists.newArrayList((Object[])biomes));
            return this;
        }

        public boolean hasType(BiomeModifications.BiomeContext ctx) {
            ResourceKey key = ResourceKey.m_135785_((ResourceKey)Registry.f_122885_, (ResourceLocation)ctx.getKey());
            if (this.DEFAULTS.contains(key)) {
                return true;
            }
            if (this.validations.containsKey(key)) {
                return this.validations.get(key);
            }
            boolean res = this.ctxValidator.test(ctx);
            this.validations.put((ResourceKey<Biome>)key, res);
            return res;
        }

        public boolean hasType(ResourceKey<Biome> biome) {
            if (this.DEFAULTS.contains(biome)) {
                return true;
            }
            if (this.validations.containsKey(biome)) {
                return this.validations.get(biome);
            }
            boolean res = this.validator.test(biome);
            this.validations.put(biome, res);
            return res;
        }
    }
}

