/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.client;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Maps;
import com.mojang.math.Vector3f;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.itsmeow.betteranimalmodels.client.forge.ReplacementsImpl;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewBee;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewCat;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewChicken;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewCow;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewDolphin;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewFox;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewHorse;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewPig;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewPolarBear;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSheep;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSilverfish;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSpider;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewSquid;
import dev.itsmeow.betteranimalmodels.client.model.ModelNewWolf;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewCatCollar;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewDolphinItem;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewFoxItem;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewHorseArmor;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewHorseMarking;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewMooshroomMushroom;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewPigSaddle;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewSheepWool;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewSpiderEyes;
import dev.itsmeow.betteranimalmodels.client.render.entity.layer.LayerNewWolfCollar;
import dev.itsmeow.betteranimalmodels.imdlib.client.IMDLibClient;
import dev.itsmeow.betteranimalmodels.imdlib.client.render.ImplRenderer;
import dev.itsmeow.betteranimalmodels.imdlib.client.util.ModelReplacementHandler;
import dev.itsmeow.betteranimalmodels.imdlib.util.SafePlatform;
import java.util.Map;
import java.util.function.BiConsumer;
import net.minecraft.Util;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.model.geom.builders.LayerDefinition;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.animal.Chicken;
import net.minecraft.world.entity.animal.Cow;
import net.minecraft.world.entity.animal.Dolphin;
import net.minecraft.world.entity.animal.Fox;
import net.minecraft.world.entity.animal.MushroomCow;
import net.minecraft.world.entity.animal.Pig;
import net.minecraft.world.entity.animal.horse.Variant;
import net.minecraft.world.level.LightLayer;

public class Replacements {
    public static final ModelReplacementHandler H = IMDLibClient.getReplacementHandler("betteranimalmodels");
    private static final Map<Variant, ResourceLocation> HORSE_VARIANTS = (Map)Util.m_137469_((Object)Maps.newEnumMap(Variant.class), m -> {
        m.put(Variant.WHITE, Replacements.t("horse/horse_white"));
        m.put(Variant.CREAMY, Replacements.t("horse/horse_creamy"));
        m.put(Variant.CHESTNUT, Replacements.t("horse/horse_chestnut"));
        m.put(Variant.BROWN, Replacements.t("horse/horse_brown"));
        m.put(Variant.BLACK, Replacements.t("horse/horse_black"));
        m.put(Variant.GRAY, Replacements.t("horse/horse_gray"));
        m.put(Variant.DARKBROWN, Replacements.t("horse/horse_darkbrown"));
    });
    public static final ImplRenderer.RenderDef<Cow, EntityModel<Cow>> cow_f = r -> r.ageScale(0.8f, 0.4f).tSingle("cow").mSingle(ModelNewCow::new, "cow");
    public static final ImplRenderer.RenderDef<Pig, EntityModel<Pig>> pig_f = r -> r.childScale(0.5f).layer(LayerNewPigSaddle::new).tSingle("pig").mSingle(ModelNewPig::new, "pig");
    public static final ImplRenderer.RenderDef<Chicken, EntityModel<Chicken>> chicken_f = r -> r.childScale(0.45f).handleRotation((e, p) -> {
        float f = e.f_28229_ + (e.f_28226_ - e.f_28229_) * p;
        float f1 = e.f_28228_ + (e.f_28227_ - e.f_28228_) * p;
        return (Mth.m_14031_((float)f) + 1.0f) * f1;
    }).tSingle("chicken").mSingle(ModelNewChicken::new, "chicken");
    public static final ImplRenderer.RenderDef<Dolphin, EntityModel<Dolphin>> dolphin_f = r -> r.layer(LayerNewDolphinItem::new).tSingle("dolphin").mSingle(ModelNewDolphin::new, "dolphin");
    public static ImplRenderer.RenderDef<Cow, EntityModel<Cow>> cow = cow_f;
    public static ImplRenderer.RenderDef<Pig, EntityModel<Pig>> pig = pig_f;
    public static ImplRenderer.RenderDef<Chicken, EntityModel<Chicken>> chicken = chicken_f;
    public static ImplRenderer.RenderDef<Dolphin, EntityModel<Dolphin>> dolphin = dolphin_f;

    public static ResourceLocation t(String s) {
        return new ResourceLocation("betteranimalmodels", "textures/entity/" + s + ".png");
    }

    public static void initQuarkReplaces() {
        H.addReplace("minecraft", "cow", () -> () -> H.lambdaReplace(EntityType.f_20557_, 1.2f, cow));
        H.addReplace("minecraft", "pig", () -> () -> H.lambdaReplace(EntityType.f_20510_, 0.7f, pig));
        H.addReplace("minecraft", "chicken", () -> () -> H.lambdaReplace(EntityType.f_20555_, 0.4f, chicken));
        H.addReplace("minecraft", "dolphin", () -> () -> H.lambdaReplace(EntityType.f_20559_, 0.7f, dolphin));
    }

    public static void init() {
        if (!SafePlatform.isModLoaded("quark")) {
            Replacements.initQuarkReplaces();
        }
        H.addReplace("minecraft", "sheep", () -> () -> H.lambdaReplace(EntityType.f_20520_, 0.7f, r -> r.childScale(0.5f).layer(LayerNewSheepWool::new).tMapped(e -> e.m_6162_() ? "lamb" : "sheep").mSingle(ModelNewSheep::new, "sheep")));
        H.addReplace("minecraft", "wolf", () -> () -> H.lambdaReplace(EntityType.f_20499_, 0.7f, r -> r.preRender((e, s, p) -> {
            s.m_85841_(0.8f, 0.8f, 0.8f);
            if (e.m_6162_()) {
                s.m_85841_(0.5f, 0.5f, 0.5f);
            }
        }).handleRotation((e, p) -> e.m_30427_()).layer(LayerNewWolfCollar::new).tMapped(e -> e.m_21824_() ? "wolf/wolf_tame" : (e.m_21660_() ? "wolf/wolf_angry" : "wolf/wolf")).mSingle(ModelNewWolf::new, "wolf")));
        H.addReplace("minecraft", "mooshroom", () -> () -> H.lambdaReplace(EntityType.f_20504_, 1.2f, r -> r.preRender((e, s, p) -> {
            if (e.m_6162_()) {
                s.m_85841_(0.36f, 0.36f, 0.36f);
            }
        }).layer(LayerNewMooshroomMushroom::new).tCondition(e -> e.m_28955_() == MushroomCow.MushroomType.RED, "mooshroom", "mooshroom_brown").mSingle(ModelNewCow::new, "cow")));
        H.addReplace("minecraft", "squid", () -> () -> H.lambdaReplace(EntityType.f_20480_, 0.7f, r -> r.applyRotations((e, s, a, rot, p) -> {
            float f = e.f_29950_ + (e.f_29938_ - e.f_29950_) * p;
            float f1 = e.f_29939_ + (e.f_29951_ - e.f_29939_) * p;
            s.m_85837_(0.0, 0.5, 0.0);
            s.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rot));
            s.m_85845_(Vector3f.f_122223_.m_122240_(f));
            s.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            s.m_85837_(0.0, (double)-1.2f, 0.0);
        }).handleRotation((e, p) -> -(e.f_29943_ + (e.f_29942_ - e.f_29943_) * p)).tSingle("squid").mSingle(ModelNewSquid::new, "squid")));
        H.addReplace("minecraft", "glow_squid", () -> () -> H.lambdaReplace(EntityType.f_147034_, 0.7f, r -> r.applyRotations((e, s, a, rot, p) -> {
            float f = e.f_29950_ + (e.f_29938_ - e.f_29950_) * p;
            float f1 = e.f_29939_ + (e.f_29951_ - e.f_29939_) * p;
            s.m_85837_(0.0, 0.5, 0.0);
            s.m_85845_(Vector3f.f_122225_.m_122240_(180.0f - rot));
            s.m_85845_(Vector3f.f_122223_.m_122240_(f));
            s.m_85845_(Vector3f.f_122225_.m_122240_(f1));
            s.m_85837_(0.0, (double)-1.2f, 0.0);
        }).handleRotation((e, p) -> -(e.f_29943_ + (e.f_29942_ - e.f_29943_) * p)).blockLightLevel((glowSquid, blockPos) -> {
            int i = (int)Mth.m_144920_((float)0.0f, (float)15.0f, (float)(1.0f - (float)glowSquid.m_147128_() / 10.0f));
            return i == 15 ? 15 : Math.max(i, glowSquid.m_6060_() ? 15 : glowSquid.f_19853_.m_45517_(LightLayer.BLOCK, blockPos));
        }).tSingle("glow_squid").mSingle(ModelNewSquid::new, "squid")));
        H.addReplace("minecraft", "spider", () -> () -> H.lambdaReplace(EntityType.f_20479_, 1.0f, r -> r.preRender((e, s, p) -> {
            if (e.m_33816_()) {
                s.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                s.m_85837_(0.0, 0.75, -0.5);
            }
        }).layer(LayerNewSpiderEyes::new).tSingle("spider").mSingle(ModelNewSpider::new, "spider")));
        H.addReplace("minecraft", "cavespider", () -> () -> H.lambdaReplace(EntityType.f_20554_, 0.4f, r -> r.preRender((e, s, p) -> {
            if (e.m_33816_()) {
                s.m_85845_(Vector3f.f_122223_.m_122240_(-90.0f));
                s.m_85837_(0.0, 0.75, -0.5);
            }
            s.m_85841_(0.5f, 0.5f, 0.5f);
        }).layer(LayerNewSpiderEyes::new).tSingle("cave_spider").mSingle(ModelNewSpider::new, "spider")));
        H.addReplace("minecraft", "silverfish", () -> () -> H.lambdaReplace(EntityType.f_20523_, 0.25f, r -> r.preRender((e, s, p) -> s.m_85841_(0.5f, 0.5f, 0.5f)).tSingle("silverfish").mSingle(ModelNewSilverfish::new, "silverfish")));
        H.addReplace("minecraft", "polar_bear", () -> () -> H.lambdaReplace(EntityType.f_20514_, 1.0f, r -> r.childScale(0.7f).tSingle("polar_bear").mSingle(ModelNewPolarBear::new, "polar_bear")));
        H.addReplace("minecraft", "ocelot", () -> () -> H.lambdaReplace(EntityType.f_20505_, 0.5f, r -> r.preRender((e, s, p) -> {
            s.m_85841_(0.8f, 0.8f, 0.8f);
            if (e.m_6162_()) {
                s.m_85841_(0.5f, 0.5f, 0.5f);
            }
        }).tSingle("cat/ocelot").mSingle(ModelNewCat::new, "cat")));
        Map catTextures = (Map)Util.m_137469_((Object)Maps.newHashMap(), map -> {
            map.put(0, "cat/tabby");
            map.put(1, "cat/black");
            map.put(2, "cat/red");
            map.put(3, "cat/siamese");
            map.put(4, "cat/british_shorthair");
            map.put(5, "cat/calico");
            map.put(6, "cat/persian");
            map.put(7, "cat/ragdoll");
            map.put(8, "cat/white");
            map.put(9, "cat/jellie");
            map.put(10, "cat/all_black");
        });
        H.addReplace("minecraft", "cat", () -> () -> H.lambdaReplace(EntityType.f_20553_, 0.5f, r -> r.preRender((e, s, p) -> {
            s.m_85841_(0.8f, 0.8f, 0.8f);
            if (e.m_21824_()) {
                s.m_85841_(0.9f, 0.9f, 0.9f);
            }
            if (e.m_6162_()) {
                s.m_85841_(0.5f, 0.5f, 0.5f);
            }
        }).layer(LayerNewCatCollar::new).tMapped(e -> (String)catTextures.get(e.m_28163_())).mSingle(ModelNewCat::new, "cat")));
        H.addReplace("minecraft", "fox", () -> () -> H.lambdaReplace(EntityType.f_20452_, 0.55f, r -> r.preRender((e, s, p) -> {
            if (e.m_6162_()) {
                s.m_85841_(0.5f, 0.5f, 0.5f);
            }
            if (e.m_5803_()) {
                s.m_85837_(0.0, 0.5, 0.0);
            }
            if (e.m_28555_()) {
                s.m_85837_(0.0, (double)0.2f, 0.0);
            }
        }).applyRotations((e, s, a, rot, p) -> {
            if (e.m_28557_() || e.m_28556_()) {
                s.m_85845_(Vector3f.f_122223_.m_122240_(-Mth.m_14179_((float)p, (float)e.f_19860_, (float)e.m_146909_())));
            }
        }, ImplRenderer.SuperCallApplyRotations.PRE).layer(LayerNewFoxItem::new).tMapped(e -> e.m_28554_() == Fox.Type.RED ? (e.m_5803_() ? "fox/fox_sleep" : "fox/fox") : (e.m_5803_() ? "fox/snow_fox_sleep" : "fox/snow_fox")).mSingle(ModelNewFox::new, "fox")));
        H.addReplace("minecraft", "bee", () -> () -> H.lambdaReplace(EntityType.f_20550_, 0.4f, r -> r.childScale(0.5f).tMapped(e -> e.m_21660_() ? (e.m_27856_() ? "bee/bee_angry_nectar" : "bee/bee_angry") : (e.m_27856_() ? "bee/bee_nectar" : "bee/bee")).mSingle(ModelNewBee::new, "bee")));
        H.addReplace("minecraft", "horse", () -> () -> H.lambdaReplace(EntityType.f_20457_, 1.0f, r -> r.layer(LayerNewHorseMarking::new).layer(LayerNewHorseArmor::new).childScale(0.5f).tMappedRaw(e -> HORSE_VARIANTS.get(e.m_30723_())).mSingle(ModelNewHorse::new, "horse")));
        H.addReplace("minecraft", "zombie_horse", () -> () -> H.lambdaReplace(EntityType.f_20502_, 1.0f, r -> r.childScale(0.5f).tSingle("horse/horse_zombie").mSingle(ModelNewHorse::new, "horse")));
        H.addReplace("minecraft", "skeleton_horse", () -> () -> H.lambdaReplace(EntityType.f_20525_, 1.0f, r -> r.ageScale(0.9f, 0.45f).tSingle("horse/horse_skeleton").mSingle(ModelNewHorse::new, "horse")));
        H.addReplace("minecraft", "donkey", () -> () -> H.lambdaReplace(EntityType.f_20560_, 1.0f, r -> r.ageScale(0.8f, 0.55f).tSingle("horse/donkey").mSingle(ModelNewHorse::new, "horse")));
        H.addReplace("minecraft", "mule", () -> () -> H.lambdaReplace(EntityType.f_20503_, 1.0f, r -> r.ageScale(0.85f, 0.55f).tSingle("horse/mule").mSingle(ModelNewHorse::new, "horse")));
        Replacements.platformInit();
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void platformInit() {
        ReplacementsImpl.platformInit();
    }

    public static void layerDefinitions(ImmutableMap.Builder<ModelLayerLocation, LayerDefinition> b) {
        BiConsumer<String, LayerDefinition> r = (k, l) -> b.put((Object)new ModelLayerLocation(new ResourceLocation("betteranimalmodels", k), "main"), l);
        r.accept("bee", ModelNewBee.createBodyLayer());
        r.accept("cat", ModelNewCat.createBodyLayer());
        r.accept("chicken", ModelNewChicken.createBodyLayer());
        r.accept("cow", ModelNewCow.createBodyLayer());
        r.accept("dolphin", ModelNewDolphin.createBodyLayer());
        r.accept("fox", ModelNewFox.createBodyLayer());
        r.accept("pig", ModelNewPig.createBodyLayer());
        r.accept("sheep", ModelNewSheep.createBodyLayer());
        r.accept("silverfish", ModelNewSilverfish.createBodyLayer());
        r.accept("spider", ModelNewSpider.createBodyLayer());
        r.accept("squid", ModelNewSquid.createBodyLayer());
        r.accept("wolf", ModelNewWolf.createBodyLayer());
        r.accept("polar_bear", ModelNewPolarBear.createBodyLayer());
        r.accept("horse", ModelNewHorse.createBodyLayer());
    }
}

