/*
 * Decompiled with CFR 0.152.
 */
package dev.itsmeow.betteranimalmodels.imdlib.entity.util;

import com.google.common.collect.Lists;
import dev.architectury.injectables.annotations.ExpectPlatform;
import dev.architectury.registry.level.biome.BiomeModifications;
import dev.itsmeow.betteranimalmodels.imdlib.IMDLib;
import dev.itsmeow.betteranimalmodels.imdlib.entity.util.fabric.BiomeTypesImpl;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_2385;
import net.minecraft.class_2960;
import net.minecraft.class_3528;
import net.minecraft.class_5321;

public class BiomeTypes {
    public static Type HOT;
    public static Type COLD;
    public static Type SPARSE;
    public static Type DENSE;
    public static Type WET;
    public static Type DRY;
    public static Type SAVANNA;
    public static Type CONIFEROUS;
    public static Type JUNGLE;
    public static Type SPOOKY;
    public static Type DEAD;
    public static Type LUSH;
    public static Type MUSHROOM;
    public static Type MAGICAL;
    public static Type RARE;
    public static Type PLATEAU;
    public static Type MODIFIED;
    public static Type OCEAN;
    public static Type RIVER;
    public static Type WATER;
    public static Type BADLANDS;
    public static Type FOREST;
    public static Type PLAINS;
    public static Type HILL;
    public static Type SWAMP;
    public static Type SANDY;
    public static Type SNOWY;
    public static Type WASTELAND;
    public static Type BEACH;
    public static Type VOID;
    public static Type UNDERGROUND;
    public static Type PEAK;
    public static Type SLOPE;
    public static Type MOUNTAIN;
    public static Type OVERWORLD;
    public static Type NETHER;
    public static Type END;
    public static final class_3528<class_2385<class_1959>> REG;

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static void init() {
        BiomeTypesImpl.init();
    }

    public static Set<Type> getTypes(BiomeModifications.BiomeContext ctx) {
        return Type.TYPES.stream().filter(t -> t.hasType(ctx)).collect(Collectors.toSet());
    }

    public static Set<Type> getTypes(class_5321<class_1959> biome) {
        return Type.TYPES.stream().filter(t -> t.hasType(biome)).collect(Collectors.toSet());
    }

    public static Set<class_5321<class_1959>> getBiomes(Type type) {
        class_2378 reg = null;
        try {
            reg = IMDLib.getStaticServerInstance().method_30611().method_30530(class_2378.field_25114);
        }
        catch (RuntimeException e) {
            return new HashSet<class_5321<class_1959>>();
        }
        Set<class_5321<class_1959>> res = reg.method_10220().map(arg_0 -> ((class_2378)reg).method_29113(arg_0)).filter(Optional::isPresent).map(Optional::get).filter(type::hasType).collect(Collectors.toSet());
        return res;
    }

    static {
        REG = new class_3528(() -> IMDLib.getStaticServerInstance().method_30611().method_30530(class_2378.field_25114));
        BiomeTypes.init();
    }

    public static class Type {
        protected static Set<Type> TYPES = new HashSet<Type>();
        private final Predicate<class_5321<class_1959>> validator;
        private final Predicate<BiomeModifications.BiomeContext> ctxValidator;
        private final Map<class_5321<class_1959>, Boolean> validations = new HashMap<class_5321<class_1959>, Boolean>();
        private final Set<class_5321<class_1959>> DEFAULTS = new HashSet<class_5321<class_1959>>();

        public Type(Predicate<class_5321<class_1959>> validator, Predicate<BiomeModifications.BiomeContext> ctxValidator) {
            this.validator = validator;
            this.ctxValidator = ctxValidator;
            TYPES.add(this);
        }

        public Type addDefaults(class_5321<class_1959> ... biomes) {
            this.DEFAULTS.addAll(Lists.newArrayList((Object[])biomes));
            return this;
        }

        public boolean hasType(BiomeModifications.BiomeContext ctx) {
            if (ctx.getKey().isEmpty()) {
                return false;
            }
            class_5321 key = class_5321.method_29179((class_5321)class_2378.field_25114, (class_2960)((class_2960)ctx.getKey().get()));
            if (this.DEFAULTS.contains(key)) {
                return true;
            }
            if (this.validations.containsKey(key)) {
                return this.validations.get(key);
            }
            boolean res = this.ctxValidator.test(ctx);
            this.validations.put((class_5321<class_1959>)key, res);
            return res;
        }

        public boolean hasType(class_5321<class_1959> biome) {
            if (this.DEFAULTS.contains(biome)) {
                return true;
            }
            if (this.validations.containsKey(biome)) {
                return this.validations.get(biome);
            }
            boolean res = this.validator.test(biome);
            this.validations.put(biome, res);
            return res;
        }
    }
}

