/*
 * Decompiled with CFR 0.152.
 */
package me.shedaniel.fiber2cloth.impl;

import com.google.common.collect.Maps;
import io.github.fablabsmc.fablabs.api.fiber.v1.exception.FiberConversionException;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.EnumSerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.SerializableType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.ConfigTypes;
import io.github.fablabsmc.fablabs.api.fiber.v1.schema.type.derived.EnumConfigType;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.Commentable;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigBranch;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigLeaf;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.ConfigNode;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.Property;
import io.github.fablabsmc.fablabs.api.fiber.v1.tree.PropertyMirror;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.DropdownBoxEntry;
import me.shedaniel.clothconfig2.gui.entries.TooltipListEntry;
import me.shedaniel.clothconfig2.impl.builders.DropdownMenuBuilder;
import me.shedaniel.fiber2cloth.api.ClothAttributes;
import me.shedaniel.fiber2cloth.api.ClothSetting;
import me.shedaniel.fiber2cloth.api.DefaultTypes;
import me.shedaniel.fiber2cloth.api.Fiber2Cloth;
import me.shedaniel.fiber2cloth.api.GuiEntryProvider;
import me.shedaniel.fiber2cloth.impl.ColorPickerFormat;
import me.shedaniel.fiber2cloth.impl.GroupDisplayOption;
import net.minecraft.class_1074;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2588;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class Fiber2ClothImpl
implements Fiber2Cloth {
    public static final EnumConfigType<ClothSetting.EnumHandler.EnumDisplayOption> ENUM_DISPLAY_TYPE = ConfigTypes.makeEnum(ClothSetting.EnumHandler.EnumDisplayOption.class);
    private final String modId;
    private final class_437 parentScreen;
    private class_2561 defaultCategory = class_2561.method_43471((String)"config.fiber2cloth.default.category");
    private class_2561 title;
    private final ConfigBranch root;
    private ConfigBranch defaultCategoryBranch;
    private final Map<Class<? extends SerializableType<?>>, Function<ConfigLeaf<?>, List<AbstractConfigListEntry<?>>>> functionMap = Maps.newHashMap();
    private final Map<ConfigNode, Function<ConfigNode, List<AbstractConfigListEntry<?>>>> nodeEntryMap = Maps.newHashMap();
    private final ConfigEntryBuilder configEntryBuilder = ConfigEntryBuilder.create();
    private Runnable saveRunnable;
    private Consumer<class_437> afterInitConsumer = screen -> {};

    @Deprecated
    public Fiber2ClothImpl(class_437 parentScreen, String modId, ConfigBranch root, class_2561 title) {
        this.parentScreen = parentScreen;
        this.root = root;
        this.defaultCategoryBranch = root;
        this.modId = modId;
        this.title = title;
        this.initDefaultFunctionMap();
    }

    private static <S, T> Optional<class_2561> error(ConfigType<T, S, ?> type, SerializableType<S> constraints, T value) {
        try {
            S v = type.toSerializedType(value);
            return Fiber2ClothImpl.error(constraints, v);
        }
        catch (FiberConversionException e) {
            return Optional.of(class_2561.method_43469((String)"error.fiber2cloth.when.casting", (Object[])new Object[]{e.getMessage()}));
        }
    }

    private static <S> Optional<class_2561> error(SerializableType<S> constraints, S v) {
        if (!constraints.accepts(v)) {
            return Optional.of(class_2561.method_43469((String)"error.fiber2cloth.invalid.value", (Object[])new Object[]{v, constraints}));
        }
        return Optional.empty();
    }

    private static List<String> gatherLocalizedLines(String tt) {
        ArrayList<String> lines = new ArrayList<String>();
        if (class_1074.method_4663((String)tt)) {
            lines.add(class_1074.method_4662((String)tt, (Object[])new Object[0]));
        }
        int i = 1;
        while (class_1074.method_4663((String)(tt + "[" + i + "]"))) {
            lines.add(class_1074.method_4662((String)(tt + "[" + i + "]"), (Object[])new Object[0]));
            ++i;
        }
        return lines;
    }

    @Override
    public Fiber2Cloth setDefaultCategoryBranch(ConfigBranch defaultCategoryNode) {
        if (!this.root.getItems().contains(defaultCategoryNode)) {
            throw new IllegalArgumentException("The default category node must be on the first level!");
        }
        this.defaultCategoryBranch = Objects.requireNonNull(defaultCategoryNode);
        return this;
    }

    @Override
    public ConfigBranch getDefaultCategoryBranch() {
        return this.defaultCategoryBranch;
    }

    @Override
    public Fiber2Cloth setAfterInitConsumer(Consumer<class_437> afterInitConsumer) {
        this.afterInitConsumer = Objects.requireNonNull(afterInitConsumer);
        return this;
    }

    @Override
    public Consumer<class_437> getAfterInitConsumer() {
        return this.afterInitConsumer;
    }

    @Override
    public Fiber2Cloth setSaveRunnable(Runnable saveRunnable) {
        this.saveRunnable = saveRunnable;
        return this;
    }

    @Override
    public Fiber2Cloth registerNodeEntryFunction(ConfigNode node, Function<ConfigNode, List<AbstractConfigListEntry<?>>> function) {
        this.nodeEntryMap.put(node, function);
        return this;
    }

    @Override
    public Map<Class<? extends SerializableType<?>>, Function<ConfigLeaf<?>, List<AbstractConfigListEntry<?>>>> getFunctionMap() {
        return this.functionMap;
    }

    @Override
    public <R, S, T extends SerializableType<S>> Fiber2Cloth registerLeafEntryFunction(ConfigType<R, S, T> type, GuiEntryProvider<R, S, T> function) {
        Class<?> cls = type.getSerializedType().getClass();
        Function<ConfigLeaf, List> f = leaf -> {
            if (((SerializableType)type.getSerializedType()).isAssignableFrom(leaf.getConfigType())) {
                PropertyMirror mirror = PropertyMirror.create(type);
                mirror.mirror((Property<?>)leaf);
                SerializableType actualType = (SerializableType)cls.cast(leaf.getConfigType());
                ConfigLeaf l = leaf;
                List<AbstractConfigListEntry<?>> entries = function.apply(l, actualType, mirror, type.toRuntimeType(l.getDefaultValue()), v -> Fiber2ClothImpl.error(type, actualType, v));
                if (entries != null) {
                    return entries;
                }
            }
            return Collections.emptyList();
        };
        this.functionMap.merge(cls, f, (f1, f2) -> v -> {
            List res = (List)f2.apply(v);
            return res == null || res.isEmpty() ? (List)f1.apply(v) : res;
        });
        return this;
    }

    private void initDefaultFunctionMap() {
        this.registerLeafEntryFunction(ConfigTypes.DOUBLE, (leaf, type, mirror, defaultValue, errorSupplier) -> {
            if (leaf.getAttributeValue(ClothAttributes.SLIDER, ConfigTypes.BOOLEAN).orElse(false).booleanValue()) {
                if (type.getMinimum() == null || type.getMaximum() == null || type.getIncrement() == null) {
                    throw new IllegalStateException("Cannot build a slider without a minimum, a maximum, and a step (" + leaf + ")");
                }
                BigDecimal step = type.getIncrement();
                BigDecimal min = type.getMinimum();
                BigDecimal max = type.getMaximum();
                long scaledCurrent = ((BigDecimal)leaf.getValue()).subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                long scaledDefault = ((BigDecimal)leaf.getDefaultValue()).subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                long scaledMax = max.subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                return Collections.singletonList(this.configEntryBuilder.startLongSlider(this.getFieldNameKey(leaf.getName()), scaledCurrent, 0L, scaledMax).setDefaultValue(scaledDefault).setSaveConsumer(v -> leaf.setValue(BigDecimal.valueOf(v).multiply(step).add(min))).setErrorSupplier(v -> Fiber2ClothImpl.error(type, BigDecimal.valueOf(v).multiply(step).add(min))).setTextGetter(v -> {
                    BigDecimal val = BigDecimal.valueOf(v);
                    return class_2561.method_43469((String)"gui.fiber2cloth.slider.value", (Object[])new Object[]{val.multiply(step).add(min).setScale(step.scale(), RoundingMode.FLOOR)});
                }).build());
            }
            return Collections.singletonList(this.configEntryBuilder.startDoubleField(this.getFieldNameKey(leaf.getName()), ((Double)mirror.getValue()).doubleValue()).setDefaultValue(defaultValue.doubleValue()).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build());
        });
        this.registerLeafEntryFunction(ConfigTypes.LONG, (leaf, type, mirror, defaultValue, errorSupplier) -> {
            long max;
            long min;
            long step;
            assert (type.getMinimum() != null && type.getMaximum() != null && type.getIncrement() != null);
            try {
                step = type.getIncrement().longValueExact();
                min = type.getMinimum().longValueExact();
                max = type.getMaximum().longValueExact();
            }
            catch (ArithmeticException e) {
                return null;
            }
            if (leaf.getAttributeValue(ClothAttributes.SLIDER, ConfigTypes.BOOLEAN).orElse(false).booleanValue()) {
                long scaledCurrent = ((BigDecimal)leaf.getValue()).subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                long scaledDefault = ((BigDecimal)leaf.getDefaultValue()).subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                long scaledMax = type.getMaximum().subtract(type.getMinimum()).divide(type.getIncrement(), RoundingMode.FLOOR).longValue();
                return Collections.singletonList(this.configEntryBuilder.startLongSlider(this.getFieldNameKey(leaf.getName()), scaledCurrent, 0L, scaledMax).setDefaultValue(scaledDefault).setSaveConsumer(v -> mirror.setValue(v * step + min)).setErrorSupplier(v -> Fiber2ClothImpl.error(ConfigTypes.LONG, type, v * step + min)).setTextGetter(v -> class_2561.method_43469((String)"gui.fiber2cloth.slider.value", (Object[])new Object[]{v * step + min})).build());
            }
            return Collections.singletonList(this.configEntryBuilder.startLongField(this.getFieldNameKey(leaf.getName()), ((Long)mirror.getValue()).longValue()).setDefaultValue(defaultValue.longValue()).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).setMin(min).setMax(max).build());
        });
        this.registerLeafEntryFunction(ConfigTypes.INTEGER, (leaf, type, mirror, defaultValue, errorSupplier) -> leaf.getAttributeValue(ClothAttributes.COLOR_PICKER, ColorPickerFormat.TYPE).map(t -> this.configEntryBuilder.startColorField(this.getFieldNameKey(leaf.getName()), ((Integer)mirror.getValue()).intValue()).setDefaultValue(defaultValue.intValue()).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).setAlphaMode(t == ColorPickerFormat.ARGB).build()).map(Collections::singletonList).orElse(null));
        this.registerLeafEntryFunction(ConfigTypes.BOOLEAN, (leaf, type, mirror, defaultValue, errorSupplier) -> {
            String s = "config." + this.modId + "." + leaf.getName();
            return Collections.singletonList(this.configEntryBuilder.startBooleanToggle(this.getFieldNameKey(leaf.getName()), ((Boolean)mirror.getValue()).booleanValue()).setDefaultValue(defaultValue.booleanValue()).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).setYesNoTextSupplier(bool -> {
                if (class_1074.method_4663((String)(s + ".boolean." + bool))) {
                    return class_2561.method_43471((String)(s + ".boolean." + bool));
                }
                return class_2561.method_43470((String)(bool != false ? "\u00a7aYes" : "\u00a7cNo"));
            }).build());
        });
        this.functionMap.put(EnumSerializableType.class, node -> {
            assert (node.getConfigType().getErasedPlatformType() == String.class);
            ConfigLeaf leaf = node;
            EnumSerializableType type = (EnumSerializableType)leaf.getConfigType();
            ClothSetting.EnumHandler.EnumDisplayOption displayOption = leaf.getAttributeValue(ClothAttributes.SUGGESTION_ENUM, ENUM_DISPLAY_TYPE).orElse(ClothSetting.EnumHandler.EnumDisplayOption.BUTTON);
            String key = "config." + this.modId + "." + leaf.getName();
            if (displayOption == ClothSetting.EnumHandler.EnumDisplayOption.BUTTON) {
                return Collections.singletonList(this.configEntryBuilder.startSelector(this.getFieldNameKey(leaf.getName()), (Object[])type.getValidValues().toArray(new String[0]), (Object)((String)leaf.getValue())).setDefaultValue((Object)((String)leaf.getDefaultValue())).setSaveConsumer(leaf::setValue).setErrorSupplier(v -> Fiber2ClothImpl.error(type, v)).setNameProvider(name -> {
                    if (class_1074.method_4663((String)(key + ".enum." + name.toLowerCase(Locale.ROOT)))) {
                        return class_2561.method_43471((String)(key + ".enum." + name.toLowerCase(Locale.ROOT)));
                    }
                    return class_2561.method_43470((String)name);
                }).build());
            }
            return Collections.singletonList(this.configEntryBuilder.startDropdownMenu(this.getFieldNameKey(leaf.getName()), (Object)((String)leaf.getValue()), s -> type.accepts(s) ? s : null).setDefaultValue((Object)((String)leaf.getDefaultValue())).setSaveConsumer(leaf::setValue).setSelections(type.getValidValues()).setSuggestionMode(displayOption == ClothSetting.EnumHandler.EnumDisplayOption.SUGGESTION_INPUT).build());
        });
        this.registerLeafEntryFunction(ConfigTypes.STRING, (leaf, type, mirror, defaultValue, errorSupplier) -> Collections.singletonList(this.configEntryBuilder.startStrField(this.getFieldNameKey(leaf.getName()), (String)mirror.getValue()).setDefaultValue(defaultValue).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build()));
        this.registerLeafEntryFunction(DefaultTypes.IDENTIFIER_TYPE, (leaf, type, mirror, defaultValue, suggestedErrorSupplier) -> leaf.getAttributeValue(ClothAttributes.REGISTRY_INPUT, DefaultTypes.IDENTIFIER_TYPE).map(arg_0 -> ((class_2378)class_2378.field_11144).method_10223(arg_0)).map(registry -> {
            DropdownBoxEntry.SelectionTopCellElement topCellElement = registry == class_2378.field_11146 ? DropdownMenuBuilder.TopCellElementBuilder.ofBlockIdentifier((class_2248)((class_2248)class_2378.field_11146.method_10223((class_2960)mirror.getValue()))) : (registry == class_2378.field_11142 ? DropdownMenuBuilder.TopCellElementBuilder.ofItemIdentifier((class_1792)((class_1792)class_2378.field_11142.method_10223((class_2960)mirror.getValue()))) : DropdownMenuBuilder.TopCellElementBuilder.of((Object)((class_2960)mirror.getValue()), s -> Optional.ofNullable(class_2960.method_12829((String)s)).filter(identifier -> registry.method_10250(identifier)).orElse(null)));
            return this.configEntryBuilder.startDropdownMenu(this.getFieldNameKey(leaf.getName()), topCellElement).setSelections((Iterable)registry.method_10235()).setDefaultValue(defaultValue).setSaveConsumer(mirror::setValue).build();
        }).map(Collections::singletonList).orElse(null));
        this.registerLeafEntryFunction(ConfigTypes.makeList(ConfigTypes.DOUBLE), (leaf, type, mirror, defaultValue, errorSupplier) -> Collections.singletonList(this.configEntryBuilder.startDoubleList(this.getFieldNameKey(leaf.getName()), (List)mirror.getValue()).setDefaultValue(defaultValue).setExpanded(true).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build()));
        this.registerLeafEntryFunction(ConfigTypes.makeList(ConfigTypes.LONG), (leaf, type, mirror, defaultValue, errorSupplier) -> Collections.singletonList(this.configEntryBuilder.startLongList(this.getFieldNameKey(leaf.getName()), (List)mirror.getValue()).setDefaultValue(defaultValue).setExpanded(true).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build()));
        this.registerLeafEntryFunction(ConfigTypes.makeList(ConfigTypes.INTEGER), (leaf, type, mirror, defaultValue, errorSupplier) -> Collections.singletonList(this.configEntryBuilder.startIntList(this.getFieldNameKey(leaf.getName()), (List)mirror.getValue()).setDefaultValue(defaultValue).setExpanded(true).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build()));
        this.registerLeafEntryFunction(ConfigTypes.makeList(ConfigTypes.STRING), (leaf, type, mirror, defaultValue, errorSupplier) -> Collections.singletonList(this.configEntryBuilder.startStrList(this.getFieldNameKey(leaf.getName()), (List)mirror.getValue()).setDefaultValue(defaultValue).setExpanded(true).setSaveConsumer(mirror::setValue).setErrorSupplier(errorSupplier).build()));
    }

    private class_2561 getFieldNameKey(String name) {
        return class_2561.method_43471((String)("config." + this.modId + "." + name));
    }

    @Override
    public ConfigBranch getConfigRoot() {
        return this.root;
    }

    @Override
    public class_437 getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public class_2561 getDefaultCategory() {
        return this.defaultCategory;
    }

    @Override
    public class_2561 getTitleText() {
        return this.title;
    }

    @Override
    public Fiber2Cloth setTitleText(class_2561 title) {
        this.title = Objects.requireNonNull(title);
        return this;
    }

    @Override
    public Fiber2Cloth setDefaultCategory(class_2561 key) {
        this.defaultCategory = key;
        return this;
    }

    @Override
    public Fiber2Cloth.Result build() {
        try {
            class_2561 defaultS;
            ConfigBuilder builder = ConfigBuilder.create().setTitle(this.getTitleText()).setParentScreen(this.getParentScreen());
            this.transformNode(builder, this.getConfigRoot());
            this.getConfigRoot().getAttributeValue(ClothAttributes.DEFAULT_BACKGROUND, DefaultTypes.IDENTIFIER_TYPE).ifPresent(arg_0 -> ((ConfigBuilder)builder).setDefaultBackgroundTexture(arg_0));
            this.getConfigRoot().getAttributeValue(ClothAttributes.TRANSPARENT_BACKGROUND, ConfigTypes.BOOLEAN).ifPresent(arg_0 -> ((ConfigBuilder)builder).setTransparentBackground(arg_0));
            class_2561 class_25612 = defaultS = this.defaultCategoryBranch == this.root ? this.getDefaultCategory() : this.getFieldNameKey(this.defaultCategoryBranch.getName());
            if (builder.hasCategory(defaultS)) {
                builder.setFallbackCategory(builder.getOrCreateCategory(defaultS));
            } else if (this.defaultCategoryBranch != this.root) {
                new IllegalStateException("Illegal default config category!").printStackTrace();
                return new Fiber2Cloth.Result(){

                    @Override
                    public boolean isSuccessful() {
                        return false;
                    }

                    @Override
                    public class_437 getScreen() {
                        return null;
                    }
                };
            }
            if (this.saveRunnable != null) {
                builder.setSavingRunnable(this.saveRunnable);
            }
            final class_437 screen = builder.setAfterInitConsumer(this.afterInitConsumer).build();
            return new Fiber2Cloth.Result(){

                @Override
                public boolean isSuccessful() {
                    return true;
                }

                @Override
                public class_437 getScreen() {
                    return screen;
                }
            };
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return new Fiber2Cloth.Result(){

                @Override
                public boolean isSuccessful() {
                    return false;
                }

                @Override
                public class_437 getScreen() {
                    return null;
                }
            };
        }
    }

    private void transformNode(ConfigBuilder builder, ConfigBranch configNode) {
        for (ConfigNode item : configNode.getItems()) {
            List<AbstractConfigListEntry<?>> entries;
            ConfigCategory category;
            if (this.nodeEntryMap.containsKey(item)) {
                category = this.getOrCreateCategory(builder, this.getDefaultCategory(), this.root);
                entries = this.appendEntries(new ArrayList(), item, this.nodeEntryMap.get(item));
            } else if (item instanceof ConfigLeaf) {
                ConfigLeaf value = (ConfigLeaf)item;
                category = this.getOrCreateCategory(builder, this.getDefaultCategory(), this.root);
                entries = this.appendEntries(new ArrayList(), value, this.functionMap.get(value.getConfigType().getClass()));
            } else {
                if (!(item instanceof ConfigBranch)) continue;
                ConfigBranch branch = (ConfigBranch)item;
                if (branch.getAttributeValue(ClothAttributes.GROUP_DISPLAY, GroupDisplayOption.TYPE).orElse(GroupDisplayOption.DEFAULT).isCategoryCandidate()) {
                    class_2561 categoryKey = this.getFieldNameKey(branch.getName());
                    if (builder.hasCategory(categoryKey)) {
                        throw new IllegalStateException("Duplicate category " + categoryKey);
                    }
                    category = this.getOrCreateCategory(builder, categoryKey, branch);
                    entries = this.transformNodeFirstLayer(branch.getName(), branch);
                } else {
                    category = this.getOrCreateCategory(builder, this.getDefaultCategory(), this.root);
                    entries = this.appendSubCategory(null, new ArrayList(), branch);
                }
            }
            entries.forEach(arg_0 -> ((ConfigCategory)category).addEntry(arg_0));
        }
    }

    private ConfigCategory getOrCreateCategory(ConfigBuilder builder, class_2561 key, ConfigNode node) {
        ConfigCategory defaultCategory = builder.getOrCreateCategory(key);
        node.getAttributeValue(ClothAttributes.CATEGORY_BACKGROUND, DefaultTypes.IDENTIFIER_TYPE).ifPresent(arg_0 -> ((ConfigCategory)defaultCategory).setCategoryBackground(arg_0));
        return defaultCategory;
    }

    private List<AbstractConfigListEntry<?>> transformNodeFirstLayer(String categoryName, ConfigBranch configNode) {
        ArrayList category = new ArrayList(configNode.getItems().size());
        for (ConfigNode item : configNode.getItems()) {
            if (this.nodeEntryMap.containsKey(item)) {
                this.appendEntries(category, configNode, this.nodeEntryMap.get(item));
                continue;
            }
            if (item instanceof ConfigLeaf) {
                ConfigLeaf value = (ConfigLeaf)item;
                this.appendEntries(category, value, this.functionMap.get(value.getConfigType().getClass()));
                continue;
            }
            if (!(item instanceof ConfigBranch)) continue;
            ConfigBranch branch = (ConfigBranch)item;
            this.appendSubCategory(categoryName, category, branch);
        }
        return category;
    }

    private List<AbstractConfigListEntry> transformNodeSecondLayer(String categoryName, ConfigBranch nestedNode) {
        ArrayList entries = new ArrayList(nestedNode.getItems().size());
        for (ConfigNode item : nestedNode.getItems()) {
            if (this.nodeEntryMap.containsKey(item)) {
                this.appendEntries(entries, nestedNode, this.nodeEntryMap.get(item));
                continue;
            }
            if (item instanceof ConfigLeaf) {
                ConfigLeaf value = (ConfigLeaf)item;
                this.appendEntries(entries, value, this.functionMap.get(value.getConfigType().getClass()));
                continue;
            }
            if (!(item instanceof ConfigBranch)) continue;
            ConfigBranch branch = (ConfigBranch)item;
            this.appendSubCategory(categoryName, entries, branch);
        }
        ArrayList ret = entries;
        return ret;
    }

    private List<AbstractConfigListEntry<?>> appendSubCategory(String categoryName, List<AbstractConfigListEntry<?>> entries, ConfigBranch nestedNode) {
        String subCategoryName = (String)(categoryName == null ? "" : categoryName + ".") + nestedNode.getName();
        GroupDisplayOption groupDisplayOption = nestedNode.getAttributeValue(ClothAttributes.GROUP_DISPLAY, GroupDisplayOption.TYPE).orElse(GroupDisplayOption.DEFAULT);
        if (groupDisplayOption.isTransitive()) {
            this.addPrefixText(entries, nestedNode, this.getFieldNameKey(subCategoryName));
            this.transformNodeSecondLayer(subCategoryName, nestedNode).forEach(entries::add);
        } else {
            this.appendEntries(entries, nestedNode, n -> Collections.singletonList(this.configEntryBuilder.startSubCategory(this.getFieldNameKey(subCategoryName), this.transformNodeSecondLayer(subCategoryName, (ConfigBranch)n)).setExpanded(groupDisplayOption == GroupDisplayOption.COLLAPSIBLE_EXPANDED).build()));
        }
        return entries;
    }

    private <T extends ConfigNode> List<AbstractConfigListEntry<?>> appendEntries(List<AbstractConfigListEntry<?>> category, T value, Function<T, List<AbstractConfigListEntry<?>>> factory) {
        if (factory != null && !value.getAttributeValue(ClothAttributes.EXCLUDED, ConfigTypes.BOOLEAN).orElse(false).booleanValue()) {
            List<AbstractConfigListEntry<?>> entries = factory.apply(value);
            for (AbstractConfigListEntry<?> entry : entries) {
                if (entry instanceof TooltipListEntry) {
                    Optional<class_2561[]> tooltip;
                    Optional rawTooltip = value.getAttributeValue(ClothAttributes.TOOLTIP, ConfigTypes.STRING);
                    if (rawTooltip.isPresent()) {
                        tooltip = rawTooltip.map(key -> key.isEmpty() ? entry.getFieldName().getString() + "@Tooltip" : key).map(Fiber2ClothImpl::gatherLocalizedLines).map(strings -> strings.stream().map(class_2561::method_43470).collect(Collectors.toList())).map(l -> l.toArray(new class_2561[0]));
                    } else {
                        String comment = value instanceof Commentable ? ((Commentable)((Object)value)).getComment() : null;
                        tooltip = Optional.ofNullable(comment).map(s -> s.split("\n")).map(Arrays::asList).map(strings -> strings.stream().map(class_2561::method_43470).collect(Collectors.toList())).map(l -> l.toArray(new class_2561[0]));
                    }
                    ((TooltipListEntry)entry).setTooltipSupplier(() -> tooltip);
                }
                this.addPrefixText(category, value, entry.getFieldName());
                value.getAttributeValue(ClothAttributes.REQUIRES_RESTART, ConfigTypes.BOOLEAN).ifPresent(arg_0 -> entry.setRequiresRestart(arg_0));
                category.add(entry);
            }
        }
        return category;
    }

    private void addPrefixText(List<AbstractConfigListEntry<?>> entries, ConfigNode value, class_2561 baseTranslationKey) {
        value.getAttributeValue(ClothAttributes.PREFIX_TEXT, ConfigTypes.STRING).map(key -> key.isEmpty() ? (baseTranslationKey.method_10851() instanceof class_2588 ? ((class_2588)baseTranslationKey.method_10851()).method_11022() : baseTranslationKey.getString()) + "@PrefixText" : key).map(Fiber2ClothImpl::gatherLocalizedLines).map(l -> String.join((CharSequence)"\n", l)).map(class_2561::method_43471).map(txt -> this.configEntryBuilder.startTextDescription((class_2561)txt).build()).ifPresent(entries::add);
    }
}

