/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import net.darkhax.betterburning.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;

@Mod(modid="betterburning", name="Better Burning", version="0.4.2")
public class BetterBurning {
    private final Config configuration = new Config();

    public BetterBurning() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.source.func_76347_k() && this.configuration.shouldDamageSourceCauseFire() && !event.entityLiving.func_70027_ad() && !event.entity.field_70170_p.field_72995_K) {
            event.entityLiving.func_70015_d(1);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (this.configuration.shouldSkeletonsShootFireArrows() && event.entity instanceof EntityArrow && !event.entity.field_70170_p.field_72995_K) {
            EntityArrow arrowEntity = (EntityArrow)event.entity;
            Entity shooter = arrowEntity.field_70250_c;
            if (shooter instanceof EntitySkeleton && shooter.func_70027_ad() && !shooter.field_70128_L && this.tryPercentage(this.configuration.getSkeletonFlameArrowChance())) {
                arrowEntity.func_70015_d(100);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (this.configuration.shouldFireResExtinguish() && !event.entityLiving.field_70170_p.field_72995_K && event.entityLiving.func_70027_ad() && event.entityLiving.func_70644_a(Potion.field_76426_n)) {
            event.entityLiving.func_70066_B();
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity sourceEntity;
        if (this.configuration.shouldFireDamageSpread() && !event.entity.field_70170_p.field_72995_K && (sourceEntity = event.source.func_76346_g()) instanceof EntityLivingBase) {
            EntityLivingBase sourceLiving = (EntityLivingBase)sourceEntity;
            ItemStack heldItem = sourceLiving.func_70694_bm();
            if (!(sourceLiving instanceof EntityZombie) && heldItem == null && sourceLiving.func_70027_ad() && this.tryPercentage(this.configuration.getFireDamageSpreadChance())) {
                float damage = Math.max(1.0f, event.entityLiving.field_70170_p.func_147462_b(event.entity.field_70165_t, event.entity.field_70163_u, event.entity.field_70161_v));
                event.entityLiving.func_70015_d(2 * (int)damage);
            } else if (heldItem != null && heldItem.func_77973_b() == Items.field_151033_d && this.configuration.shouldFlintAndSteelDoFireDamage()) {
                event.entityLiving.func_70015_d(this.configuration.getFlintAndSteelFireDamage());
                heldItem.func_96631_a(1, sourceLiving.func_70681_au());
            }
        }
    }

    private boolean tryPercentage(double chance) {
        return Math.random() < chance;
    }
}

