/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.betterburning;

import net.darkhax.betterburning.Config;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.EntityJoinWorldEvent;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@Mod(modid="betterburning", name="Better Burning", version="0.6.2", certificateFingerprint="d476d1b22b218a10d845928d1665d45fce301b27", acceptedMinecraftVersions="[1.9.4]")
public class BetterBurning {
    private final Config configuration = new Config();

    public BetterBurning() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    @SubscribeEvent
    public void onLivingDeath(LivingDeathEvent event) {
        if (event.getSource().func_76347_k() && this.configuration.shouldDamageSourceCauseFire() && !event.getEntityLiving().func_70027_ad() && !event.getEntity().field_70170_p.field_72995_K) {
            event.getEntityLiving().func_70015_d(1);
        }
    }

    @SubscribeEvent
    public void onEntityJoinWorld(EntityJoinWorldEvent event) {
        if (this.configuration.shouldSkeletonsShootFireArrows() && event.getEntity() instanceof EntityArrow && !event.getEntity().field_70170_p.field_72995_K) {
            EntityArrow arrowEntity = (EntityArrow)event.getEntity();
            Entity shooter = arrowEntity.field_70250_c;
            if (shooter instanceof EntitySkeleton && shooter.func_70027_ad() && !shooter.field_70128_L && this.tryPercentage(this.configuration.getSkeletonFlameArrowChance())) {
                arrowEntity.func_70015_d(100);
            }
        }
    }

    @SubscribeEvent
    public void onLivingTick(LivingEvent.LivingUpdateEvent event) {
        if (this.configuration.shouldFireResExtinguish() && !event.getEntityLiving().field_70170_p.field_72995_K && event.getEntityLiving().func_70027_ad() && event.getEntityLiving().func_70644_a(MobEffects.field_76426_n)) {
            event.getEntityLiving().func_70066_B();
        }
    }

    @SubscribeEvent
    public void onLivingAttack(LivingAttackEvent event) {
        Entity sourceEntity;
        if (this.configuration.shouldFireDamageSpread() && !event.getEntity().field_70170_p.field_72995_K && (sourceEntity = event.getSource().func_76346_g()) instanceof EntityLivingBase) {
            EntityLivingBase sourceLiving = (EntityLivingBase)sourceEntity;
            ItemStack heldItem = sourceLiving.func_184614_ca();
            if (!(sourceLiving instanceof EntityZombie) && heldItem == null && sourceLiving.func_70027_ad() && this.tryPercentage(this.configuration.getFireDamageSpreadChance())) {
                float damage = Math.max(1.0f, event.getEntityLiving().field_70170_p.func_175649_E(new BlockPos(event.getEntity())).func_180168_b());
                event.getEntityLiving().func_70015_d(2 * (int)damage);
            } else if (heldItem != null && heldItem.func_77973_b() == Items.field_151033_d && this.configuration.shouldFlintAndSteelDoFireDamage()) {
                event.getEntityLiving().func_70015_d(this.configuration.getFlintAndSteelFireDamage());
                heldItem.func_96631_a(1, sourceLiving.func_70681_au());
            }
        }
    }

    private boolean tryPercentage(double chance) {
        return Math.random() < chance;
    }
}

