/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces;

import com.google.common.collect.Lists;
import com.yungnickyoung.minecraft.bettermineshafts.BetterMineshafts;
import com.yungnickyoung.minecraft.bettermineshafts.world.BetterMineshaftStructure;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftGenerator;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.BetterMineshaftStructurePieceType;
import com.yungnickyoung.minecraft.bettermineshafts.world.generator.pieces.MineshaftPiece;
import com.yungnickyoung.minecraft.yungsapi.world.BlockSetSelector;
import com.yungnickyoung.minecraft.yungsapi.world.BoundingBoxHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1297;
import net.minecraft.class_1694;
import net.minecraft.class_1701;
import net.minecraft.class_1922;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2442;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2497;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_2794;
import net.minecraft.class_3341;
import net.minecraft.class_3443;
import net.minecraft.class_3485;
import net.minecraft.class_3545;
import net.minecraft.class_3749;
import net.minecraft.class_39;
import net.minecraft.class_4778;
import net.minecraft.class_5138;
import net.minecraft.class_5281;

public class BigTunnel
extends MineshaftPiece {
    private final List<class_2338> smallShaftLeftEntrances = Lists.newLinkedList();
    private final List<class_2338> smallShaftRightEntrances = Lists.newLinkedList();
    private final List<class_3341> sideRoomEntrances = Lists.newLinkedList();
    private final List<Integer> bigSupports = Lists.newLinkedList();
    private final List<Integer> smallSupports = Lists.newLinkedList();
    private final List<class_3545<Integer, Integer>> gravelDeposits = Lists.newLinkedList();
    private static final int SECONDARY_AXIS_LEN = 9;
    private static final int Y_AXIS_LEN = 8;
    private static final int MAIN_AXIS_LEN = 24;
    private static final int LOCAL_X_END = 8;
    private static final int LOCAL_Y_END = 7;
    private static final int LOCAL_Z_END = 23;

    public BigTunnel(class_3485 structureManager, class_2487 compoundTag) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, compoundTag);
        int i;
        class_2499 listTag1 = compoundTag.method_10554("SmallShaftLeftEntrances", 11);
        class_2499 listTag2 = compoundTag.method_10554("SmallShaftRightEntrances", 11);
        class_2499 listTag3 = compoundTag.method_10554("SideRoomEntrances", 11);
        class_2499 listTag4 = compoundTag.method_10554("BigSupports", 3);
        class_2499 listTag5 = compoundTag.method_10554("SmallSupports", 3);
        class_2499 listTag6 = compoundTag.method_10554("GravelDeposits", 11);
        for (i = 0; i < listTag1.size(); ++i) {
            this.smallShaftLeftEntrances.add(new class_2338(listTag1.method_10610(i)[0], listTag1.method_10610(i)[1], listTag1.method_10610(i)[2]));
        }
        for (i = 0; i < listTag2.size(); ++i) {
            this.smallShaftRightEntrances.add(new class_2338(listTag2.method_10610(i)[0], listTag2.method_10610(i)[1], listTag2.method_10610(i)[2]));
        }
        for (i = 0; i < listTag3.size(); ++i) {
            this.sideRoomEntrances.add(new class_3341(listTag3.method_10610(i)));
        }
        for (i = 0; i < listTag4.size(); ++i) {
            this.bigSupports.add(listTag4.method_10600(i));
        }
        for (i = 0; i < listTag5.size(); ++i) {
            this.smallSupports.add(listTag5.method_10600(i));
        }
        for (i = 0; i < listTag6.size(); ++i) {
            this.gravelDeposits.add((class_3545<Integer, Integer>)new class_3545((Object)listTag6.method_10610(i)[0], (Object)listTag6.method_10610(i)[1]));
        }
    }

    public BigTunnel(int chainLength, Random random, class_3341 blockBox, class_2350 direction, BetterMineshaftStructure.Type type) {
        super(BetterMineshaftStructurePieceType.BIG_TUNNEL, chainLength, type);
        this.method_14926(direction);
        this.field_15315 = blockBox;
    }

    @Override
    protected void method_14943(class_2487 tag) {
        super.method_14943(tag);
        class_2499 listTag1 = new class_2499();
        class_2499 listTag2 = new class_2499();
        class_2499 listTag3 = new class_2499();
        class_2499 listTag4 = new class_2499();
        class_2499 listTag5 = new class_2499();
        class_2499 listTag6 = new class_2499();
        this.smallShaftLeftEntrances.forEach(pos -> listTag1.add((Object)new class_2495(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})));
        this.smallShaftRightEntrances.forEach(pos -> listTag2.add((Object)new class_2495(new int[]{pos.method_10263(), pos.method_10264(), pos.method_10260()})));
        this.sideRoomEntrances.forEach(blockBox -> listTag3.add((Object)blockBox.method_14658()));
        this.bigSupports.forEach(z -> listTag4.add((Object)class_2497.method_23247((int)z)));
        this.smallSupports.forEach(z -> listTag5.add((Object)class_2497.method_23247((int)z)));
        this.gravelDeposits.forEach(pair -> listTag6.add((Object)new class_2495(new int[]{(Integer)pair.method_15442(), (Integer)pair.method_15441()})));
        tag.method_10566("SmallShaftLeftEntrances", (class_2520)listTag1);
        tag.method_10566("SmallShaftRightEntrances", (class_2520)listTag2);
        tag.method_10566("SideRoomEntrances", (class_2520)listTag3);
        tag.method_10566("BigSupports", (class_2520)listTag4);
        tag.method_10566("SmallSupports", (class_2520)listTag5);
        tag.method_10566("GravelDeposits", (class_2520)listTag6);
    }

    public static class_3341 determineBoxPosition(int x, int y, int z, class_2350 direction) {
        return BoundingBoxHelper.boxFromCoordsWithRotation((int)x, (int)y, (int)z, (int)9, (int)8, (int)24, (class_2350)direction);
    }

    @Override
    public void method_14918(class_3443 structurePiece, List<class_3443> list, Random random) {
        class_2350 direction = this.method_14934();
        if (direction == null) {
            return;
        }
        switch (direction) {
            default: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_15315.field_14381, this.field_15315.field_14380, this.field_15315.field_14379 - 1, direction, this.field_15316);
                break;
            }
            case field_11035: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_15315.field_14378, this.field_15315.field_14380, this.field_15315.field_14376 + 1, direction, this.field_15316);
                break;
            }
            case field_11039: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14376, direction, this.field_15316);
                break;
            }
            case field_11034: {
                BetterMineshaftGenerator.generateAndAddBigTunnelPiece(structurePiece, list, random, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379, direction, this.field_15316);
            }
        }
        int pieceLen = this.method_14934().method_10166() == class_2350.class_2351.field_11051 ? this.field_15315.method_14664() : this.field_15315.method_14660();
        this.buildSideRoomsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSideRoomsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsLeft(structurePiece, list, random, direction, pieceLen);
        this.buildSmallShaftsRight(structurePiece, list, random, direction, pieceLen);
        this.buildSupports(random);
        this.buildGravelDeposits(random);
    }

    public boolean method_14931(class_5281 world, class_5138 structureAccessor, class_2794 generator, Random random, class_3341 box, class_1923 pos, class_2338 blockPos) {
        if (this.isInOcean(world, 0, 0) || this.isInOcean(world, 8, 23)) {
            return false;
        }
        this.chanceReplaceNonAir(world, box, random, this.getReplacementRate(), 0, 0, 0, 8, 7, 23, this.getMainSelector());
        this.chanceReplaceNonAir(world, box, random, this.getReplacementRate(), 0, 0, 0, 8, 0, 23, this.getFloorSelector());
        this.fill(world, box, 1, 1, 0, 7, 4, 23, field_15314);
        this.fill(world, box, 2, 4, 0, 6, 5, 23, field_15314);
        this.fill(world, box, 3, 6, 0, 5, 6, 23, field_15314);
        this.replaceAir(world, box, 1, 0, 0, 7, 0, 23, this.getMainBlock());
        this.generateSmallShaftEntrances(world, box, random);
        this.generateSideRoomOpenings(world, box, random);
        this.generateLegs(world, box, random);
        this.generateBigSupports(world, box, random);
        this.generateSmallSupports(world, box, random);
        this.generateRails(world, box, random);
        this.generateChestCarts(world, box, random);
        this.generateTntCarts(world, box, random);
        this.generateGravelDeposits(world, box, random);
        this.addBiomeDecorations(world, box, random, 0, 0, 0, 8, 6, 23);
        this.addVines(world, box, random, 1, 0, 1, 7, 7, 22);
        this.generateLanterns(world, box, random);
        this.generateCobwebs(world, box, random);
        return true;
    }

    private void generateSmallShaftEntrances(class_5281 world, class_3341 box, Random random) {
        this.smallShaftLeftEntrances.forEach(entrancePos -> {
            int x = entrancePos.method_10263();
            int y = entrancePos.method_10264();
            int z = entrancePos.method_10260();
            this.fill(world, box, x, y, z, x, y, z + 2, field_15314);
            this.method_14917(world, this.getSupportBlock(), x, y + 1, z, box);
            this.method_14917(world, this.getSupportBlock(), x, y + 1, z + 2, box);
            this.fill(world, box, x + 1, y, z, x + 1, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x + 1, y, z + 2, x + 1, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, field_15314);
            this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
        });
        this.smallShaftRightEntrances.forEach(entrancePos -> {
            int x = entrancePos.method_10263();
            int y = entrancePos.method_10264();
            int z = entrancePos.method_10260();
            this.replaceAir(world, box, x, y - 1, z, x + 1, y - 1, z + 2, this.getMainBlock());
            this.fill(world, box, x + 1, y, z, x + 1, y, z + 2, field_15314);
            this.method_14917(world, this.getSupportBlock(), x + 1, y + 1, z, box);
            this.method_14917(world, this.getSupportBlock(), x + 1, y + 1, z + 2, box);
            this.fill(world, box, x, y, z, x, y + 1, z, this.getSupportBlock());
            this.fill(world, box, x, y, z + 2, x, y + 1, z + 2, this.getSupportBlock());
            this.chanceFill(world, box, random, 0.75f, x, y + 2, z, x + 1, y + 2, z + 2, this.getMainBlock());
            this.fill(world, box, x, y + 1, z + 1, x + 1, y + 1, z + 1, field_15314);
        });
    }

    private void generateLegs(class_5281 world, class_3341 box, Random random) {
        if (this.mineshaftType == BetterMineshaftStructure.Type.ICE || this.mineshaftType == BetterMineshaftStructure.Type.MUSHROOM) {
            this.generateLegsVariant(world, box, random);
            return;
        }
        class_2680 supportBlock = this.getSupportBlock();
        if (supportBlock.method_28501().contains(class_2741.field_22175) && supportBlock.method_28501().contains(class_2741.field_22176)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22175, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22176, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12489) && supportBlock.method_28501().contains(class_2741.field_12540)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12489, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12540, (Comparable)Boolean.valueOf(true));
        }
        BlockSetSelector legSelector = this.getLegSelector();
        this.generateLeg(world, random, box, 1, 0, legSelector);
        this.replaceAir(world, box, 1, -1, 1, 1, -1, 5, supportBlock);
        this.replaceAir(world, box, 1, -2, 1, 1, -2, 3, supportBlock);
        this.replaceAir(world, box, 1, -3, 1, 1, -3, 2, supportBlock);
        this.replaceAir(world, box, 1, -5, 1, 1, -4, 1, supportBlock);
        this.replaceAir(world, box, 1, -1, 6, 1, -1, 10, supportBlock);
        this.replaceAir(world, box, 1, -2, 8, 1, -2, 10, supportBlock);
        this.replaceAir(world, box, 1, -3, 9, 1, -3, 10, supportBlock);
        this.replaceAir(world, box, 1, -5, 10, 1, -4, 10, supportBlock);
        this.generateLeg(world, random, box, 1, 11, legSelector);
        this.generateLeg(world, random, box, 1, 12, legSelector);
        this.replaceAir(world, box, 1, -1, 13, 1, -1, 17, supportBlock);
        this.replaceAir(world, box, 1, -2, 13, 1, -2, 15, supportBlock);
        this.replaceAir(world, box, 1, -3, 13, 1, -3, 14, supportBlock);
        this.replaceAir(world, box, 1, -5, 13, 1, -4, 13, supportBlock);
        this.replaceAir(world, box, 1, -1, 18, 1, -1, 22, supportBlock);
        this.replaceAir(world, box, 1, -2, 20, 1, -2, 22, supportBlock);
        this.replaceAir(world, box, 1, -3, 21, 1, -3, 22, supportBlock);
        this.replaceAir(world, box, 1, -5, 22, 1, -4, 22, supportBlock);
        this.generateLeg(world, random, box, 1, 23, legSelector);
        this.generateLeg(world, random, box, 7, 0, legSelector);
        this.replaceAir(world, box, 7, -1, 1, 7, -1, 5, supportBlock);
        this.replaceAir(world, box, 7, -2, 1, 7, -2, 3, supportBlock);
        this.replaceAir(world, box, 7, -3, 1, 7, -3, 2, supportBlock);
        this.replaceAir(world, box, 7, -5, 1, 7, -4, 1, supportBlock);
        this.replaceAir(world, box, 7, -1, 6, 7, -1, 10, supportBlock);
        this.replaceAir(world, box, 7, -2, 8, 7, -2, 10, supportBlock);
        this.replaceAir(world, box, 7, -3, 9, 7, -3, 10, supportBlock);
        this.replaceAir(world, box, 7, -5, 10, 7, -4, 10, supportBlock);
        this.generateLeg(world, random, box, 7, 11, legSelector);
        this.generateLeg(world, random, box, 7, 12, legSelector);
        this.replaceAir(world, box, 7, -1, 13, 7, -1, 17, supportBlock);
        this.replaceAir(world, box, 7, -2, 13, 7, -2, 15, supportBlock);
        this.replaceAir(world, box, 7, -3, 13, 7, -3, 14, supportBlock);
        this.replaceAir(world, box, 7, -5, 13, 7, -4, 13, supportBlock);
        this.replaceAir(world, box, 7, -1, 18, 7, -1, 22, supportBlock);
        this.replaceAir(world, box, 7, -2, 20, 7, -2, 22, supportBlock);
        this.replaceAir(world, box, 7, -3, 21, 7, -3, 22, supportBlock);
        this.replaceAir(world, box, 7, -5, 22, 7, -4, 22, supportBlock);
        this.generateLeg(world, random, box, 7, 23, legSelector);
    }

    private void generateLegsVariant(class_5281 world, class_3341 box, Random random) {
        BlockSetSelector legSelector = this.getLegSelector();
        for (int z = 0; z <= 23; z += 7) {
            this.generateLeg(world, random, box, 2, z + 1, legSelector);
            this.generateLeg(world, random, box, 6, z + 1, legSelector);
            this.replaceAir(world, box, random, 1, -1, z, 7, -1, z + 2, legSelector);
            this.replaceAir(world, box, random, 2, -1, z + 3, 2, -1, z + 3, legSelector);
            this.replaceAir(world, box, random, 6, -1, z + 3, 6, -1, z + 3, legSelector);
            this.replaceAir(world, box, random, 3, -1, z + 3, 5, -1, z + 6, legSelector);
            this.replaceAir(world, box, random, 2, -1, z + 6, 2, -1, z + 6, legSelector);
            this.replaceAir(world, box, random, 6, -1, z + 6, 6, -1, z + 6, legSelector);
            this.replaceAir(world, box, random, 2, -2, z, 2, -2, z, legSelector);
            this.replaceAir(world, box, random, 6, -2, z, 6, -2, z, legSelector);
            this.replaceAir(world, box, random, 2, -2, z + 2, 2, -2, z + 2, legSelector);
            this.replaceAir(world, box, random, 6, -2, z + 2, 6, -2, z + 2, legSelector);
            this.replaceAir(world, box, random, 1, -2, z + 1, 1, -2, z + 1, legSelector);
            this.replaceAir(world, box, random, 7, -2, z + 1, 7, -2, z + 1, legSelector);
            this.replaceAir(world, box, random, 3, -2, z + 1, 3, -2, z + 1, legSelector);
            this.replaceAir(world, box, random, 5, -2, z + 1, 5, -2, z + 1, legSelector);
        }
    }

    private void generateGravelDeposits(class_5281 world, class_3341 box, Random random) {
        this.gravelDeposits.forEach(pair -> {
            int z = (Integer)pair.method_15442();
            int side = (Integer)pair.method_15441();
            switch (side) {
                default: {
                    this.replaceAir(world, box, 1, 1, z, 1, 2, z + 2, this.getGravel());
                    this.replaceAir(world, box, 1, 3, z + 1, 1, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 1, 3, z, 1, 3, z + 2, this.getGravel());
                    this.replaceAir(world, box, 2, 1, z + 1, 2, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAir(world, box, 2, 1, z, 2, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 3, 1, z, 3, 1, z + 2, this.getGravel());
                    break;
                }
                case 1: {
                    this.replaceAir(world, box, 7, 1, z, 7, 2, z + 2, this.getGravel());
                    this.replaceAir(world, box, 7, 3, z + 1, 7, 3 + random.nextInt(2), z + 1, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 7, 3, z, 7, 3, z + 2, this.getGravel());
                    this.replaceAir(world, box, 6, 1, z + 1, 6, 2 + random.nextInt(2), z + 1, this.getGravel());
                    this.replaceAir(world, box, 6, 1, z, 6, 1 + random.nextInt(2), z + 2, this.getGravel());
                    this.chanceReplaceAir(world, box, random, 0.5f, 5, 1, z, 5, 1, z + 2, this.getGravel());
                }
            }
        });
    }

    private void generateCobwebs(class_5281 world, class_3341 box, Random random) {
        float chance = (float)BetterMineshafts.CONFIG.spawnRates.cobwebSpawnRate;
        this.smallSupports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, chance, 2, 3, z - 1, 6, 4, z + 1, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 3, 5, (int)z, 5, 5, (int)z, class_2246.field_10343.method_9564());
        });
        this.bigSupports.forEach(z -> {
            this.chanceReplaceAir(world, box, random, chance, 1, 1, (int)z, 1, 4, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 7, 1, (int)z, 7, 4, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 2, 5, (int)z, 6, 5, z + 2, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 2, 4, z + 1, 6, 4, z + 1, class_2246.field_10343.method_9564());
            this.chanceReplaceAir(world, box, random, chance, 3, 6, z + 1, 5, 6, z + 1, class_2246.field_10343.method_9564());
        });
    }

    private void generateChestCarts(class_5281 world, class_3341 box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            class_2338 blockPos;
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.mainShaftChestMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = new class_2338(this.method_14928(4, z), this.method_14924(1), this.method_14941(4, z)))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1694 chestMinecartEntity = new class_1694((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            chestMinecartEntity.method_7562(class_39.field_472, random.nextLong());
            world.method_8649((class_1297)chestMinecartEntity);
        }
    }

    private void generateTntCarts(class_5281 world, class_3341 box, Random random) {
        for (int z = 0; z <= 23; ++z) {
            class_2338 blockPos;
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.mainShaftTntMinecartSpawnRate) || !box.method_14662((class_2382)(blockPos = new class_2338(this.method_14928(4, z), this.method_14924(1), this.method_14941(4, z)))) || world.method_8320(blockPos.method_10074()).method_26215()) continue;
            class_1701 tntMinecartEntity = new class_1701((class_1937)world.method_8410(), (double)((float)blockPos.method_10263() + 0.5f), (double)((float)blockPos.method_10264() + 0.5f), (double)((float)blockPos.method_10260() + 0.5f));
            world.method_8649((class_1297)tntMinecartEntity);
        }
    }

    private void generateBigSupports(class_5281 world, class_3341 box, Random random) {
        class_2680 supportBlock = this.getSupportBlock();
        if (supportBlock.method_28501().contains(class_2741.field_22174) && supportBlock.method_28501().contains(class_2741.field_22177)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12487) && supportBlock.method_28501().contains(class_2741.field_12527)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.bigSupports) {
            this.chanceFill(world, box, random, 0.6f, 1, 1, z, 2, 1, z + 2, this.getMainSlab());
            this.chanceFill(world, box, random, 0.6f, 6, 1, z, 7, 1, z + 2, this.getMainSlab());
            this.method_14917(world, this.getMainBlock(), 1, 1, z + 1, box);
            this.method_14917(world, this.getMainBlock(), 7, 1, z + 1, box);
            this.method_14917(world, this.getMainBlock(), 1, 4, z + 1, box);
            this.method_14917(world, this.getMainBlock(), 7, 4, z + 1, box);
            this.fill(world, box, 2, 5, z + 1, 6, 5, z + 1, this.getMainBlock());
            this.fill(world, box, 1, 2, z + 1, 1, 3, z + 1, this.getSupportBlock());
            this.fill(world, box, 7, 2, z + 1, 7, 3, z + 1, this.getSupportBlock());
            this.chanceReplaceNonAir(world, box, random, 0.4f, 2, 5, z + 1, 6, 5, z + 1, supportBlock);
        }
    }

    private void generateSmallSupports(class_5281 world, class_3341 box, Random random) {
        class_2680 supportBlock = this.getSupportBlock();
        if (supportBlock.method_28501().contains(class_2741.field_22174) && supportBlock.method_28501().contains(class_2741.field_22177)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_22174, (Comparable)class_4778.field_22180)).method_11657((class_2769)class_2741.field_22177, (Comparable)class_4778.field_22180);
        } else if (supportBlock.method_28501().contains(class_2741.field_12487) && supportBlock.method_28501().contains(class_2741.field_12527)) {
            supportBlock = (class_2680)((class_2680)supportBlock.method_11657((class_2769)class_2741.field_12487, (Comparable)Boolean.valueOf(true))).method_11657((class_2769)class_2741.field_12527, (Comparable)Boolean.valueOf(true));
        }
        for (int z : this.smallSupports) {
            this.method_14917(world, this.getMainBlock(), 2, 1, z, box);
            this.method_14917(world, this.getMainBlock(), 6, 1, z, box);
            this.method_14917(world, this.getSupportBlock(), 2, 2, z, box);
            this.method_14917(world, this.getSupportBlock(), 6, 2, z, box);
            this.method_14917(world, this.getMainBlock(), 2, 3, z, box);
            this.method_14917(world, this.getMainBlock(), 6, 3, z, box);
            this.fill(world, box, 3, 4, z, 5, 4, z, this.getMainBlock());
            this.chanceReplaceNonAir(world, box, random, 0.5f, 3, 4, z, 5, 4, z, supportBlock);
            this.chanceFill(world, box, random, 0.4f, 2, 3, z, 6, 3, z, supportBlock);
            this.method_14917(world, supportBlock, 3, 3, z, box);
            this.method_14917(world, supportBlock, 5, 3, z, box);
        }
    }

    private void generateLanterns(class_5281 world, class_3341 box, Random random) {
        class_2680 LANTERN = (class_2680)class_2246.field_16541.method_9564().method_11657((class_2769)class_3749.field_16545, (Comparable)Boolean.valueOf(true));
        for (int z = 0; z <= 23; ++z) {
            for (int x = 3; x <= 5; ++x) {
                if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.lanternSpawnRate * 3.0) || this.method_14929((class_1922)world, x, 7, z, box).method_26215()) continue;
                this.method_14917(world, LANTERN, x, 6, z, box);
                z += 20;
            }
        }
    }

    private void generateRails(class_5281 world, class_3341 box, Random random) {
        this.chanceFill(world, box, random, 0.5f, 4, 1, 0, 4, 1, 23, class_2246.field_10167.method_9564());
        int blocksSinceLastRail = 0;
        for (int n = 0; n <= 23; ++n) {
            if (random.nextInt(20) != 0 && ++blocksSinceLastRail <= 25) continue;
            this.method_14917(world, (class_2680)class_2246.field_10425.method_9564().method_11657((class_2769)class_2442.field_11364, (Comparable)Boolean.valueOf(true)), 4, 1, n, box);
            blocksSinceLastRail = 0;
        }
    }

    private void generateSideRoomOpenings(class_5281 world, class_3341 chunkBox, Random random) {
        this.sideRoomEntrances.forEach(entranceBox -> {
            this.replaceAir(world, chunkBox, random, entranceBox.field_14381, 0, entranceBox.field_14379, entranceBox.field_14378, 0, entranceBox.field_14376, this.getBrickSelector());
            switch (random.nextInt(3)) {
                case 0: {
                    this.fill(world, chunkBox, entranceBox.field_14381, entranceBox.field_14380, entranceBox.field_14379 + 2, entranceBox.field_14378, entranceBox.field_14377, entranceBox.field_14376 - 2, field_15314);
                    return;
                }
                case 1: {
                    this.fill(world, chunkBox, entranceBox.field_14381, entranceBox.field_14380, entranceBox.field_14379 + 2, entranceBox.field_14378, entranceBox.field_14377 - 1, entranceBox.field_14379 + 2, field_15314);
                    this.fill(world, chunkBox, entranceBox.field_14381, entranceBox.field_14380, entranceBox.field_14379 + 4, entranceBox.field_14378, entranceBox.field_14377 - 1, entranceBox.field_14379 + 5, field_15314);
                    this.fill(world, chunkBox, entranceBox.field_14381, entranceBox.field_14380, entranceBox.field_14379 + 7, entranceBox.field_14378, entranceBox.field_14377 - 1, entranceBox.field_14379 + 7, field_15314);
                    return;
                }
            }
        });
    }

    private void buildGravelDeposits(Random random) {
        for (int z = 0; z <= 21; ++z) {
            int r = random.nextInt(20);
            int currPos = z;
            if (r == 0) {
                this.gravelDeposits.add((class_3545<Integer, Integer>)new class_3545((Object)currPos, (Object)0));
                z += 5;
                continue;
            }
            if (r != 1) continue;
            this.gravelDeposits.add((class_3545<Integer, Integer>)new class_3545((Object)currPos, (Object)1));
            z += 5;
        }
    }

    private void buildSupports(Random random) {
        int counter = 0;
        int MAX_COUNT = 10;
        for (int z = 0; z <= 21; ++z) {
            ++counter;
            boolean blockingEntrance = false;
            for (class_2338 entrancePos : this.smallShaftLeftEntrances) {
                if (entrancePos.method_10260() > z + 2 || z > entrancePos.method_10260() + 2) continue;
                blockingEntrance = true;
                break;
            }
            for (class_2338 entrancePos : this.smallShaftRightEntrances) {
                if (entrancePos.method_10260() > z + 2 || z > entrancePos.method_10260() + 2) continue;
                blockingEntrance = true;
                break;
            }
            if (blockingEntrance) continue;
            int r = random.nextInt(8);
            if (r == 0 || counter >= 10) {
                this.bigSupports.add(z);
                counter = 0;
                z += 3;
                continue;
            }
            if (r != 1) continue;
            this.smallSupports.add(z);
            counter = 0;
            z += 3;
        }
    }

    private void buildSideRoomsLeft(class_3443 structurePiece, List<class_3443> list, Random random, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14381 - 5, this.field_15315.field_14380, this.field_15315.field_14376 - n - 9, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14378 + 5, this.field_15315.field_14380, this.field_15315.field_14379 + n + 9, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14378 - n - 9, this.field_15315.field_14380, this.field_15315.field_14376 + 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14381 + n + 9, this.field_15315.field_14380, this.field_15315.field_14379 - 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSideRoomsRight(class_3443 structurePiece, List<class_3443> list, Random random, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 10; ++n) {
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.workstationSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14378 + 5, this.field_15315.field_14380, this.field_15315.field_14376 - n, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14381 - 5, this.field_15315.field_14380, this.field_15315.field_14379 + n, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14378 - n, this.field_15315.field_14380, this.field_15315.field_14379 - 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(0, 1, n, 0, 3, n + 9));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSideRoomPiece(structurePiece, list, random, this.field_15315.field_14381 + n, this.field_15315.field_14380, this.field_15315.field_14376 + 5, nextPieceDirection, this.field_15316);
                    if (newPiece == null) break;
                    this.sideRoomEntrances.add(new class_3341(8, 1, n, 8, 3, n + 9));
                }
            }
            n += 10;
        }
    }

    private void buildSmallShaftsLeft(class_3443 structurePiece, List<class_3443> list, Random random, class_2350 direction, int pieceLen) {
        for (int n = 0; n < pieceLen - 1 - 4; ++n) {
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14376 - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n + 1));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14379 + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n + 1));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14378 - n, this.field_15315.field_14380, this.field_15315.field_14376 + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n + 1));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14381 + n, this.field_15315.field_14380, this.field_15315.field_14379 - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n + 1));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }

    private void buildSmallShaftsRight(class_3443 structurePiece, List<class_3443> list, Random random, class_2350 direction, int pieceLen) {
        for (int n = 5; n < pieceLen; ++n) {
            if (!((double)random.nextFloat() < BetterMineshafts.CONFIG.spawnRates.smallShaftSpawnRate)) continue;
            switch (direction) {
                default: {
                    class_2350 nextPieceDirection = class_2350.field_11034;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14378 + 1, this.field_15315.field_14380, this.field_15315.field_14376 - n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n - 3));
                    break;
                }
                case field_11035: {
                    class_2350 nextPieceDirection = class_2350.field_11039;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14381 - 1, this.field_15315.field_14380, this.field_15315.field_14379 + n, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n - 3));
                    break;
                }
                case field_11039: {
                    class_2350 nextPieceDirection = class_2350.field_11043;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14378 - n, this.field_15315.field_14380, this.field_15315.field_14379 - 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftLeftEntrances.add(new class_2338(0, 1, n - 3));
                    break;
                }
                case field_11034: {
                    class_2350 nextPieceDirection = class_2350.field_11035;
                    MineshaftPiece newPiece = BetterMineshaftGenerator.generateAndAddSmallTunnelPiece(structurePiece, list, random, this.field_15315.field_14381 + n, this.field_15315.field_14380, this.field_15315.field_14376 + 1, nextPieceDirection, 0);
                    if (newPiece == null) break;
                    this.smallShaftRightEntrances.add(new class_2338(7, 1, n - 3));
                }
            }
            n += random.nextInt(7) + 5;
        }
    }
}

