/*
 * Decompiled with CFR 0.152.
 */
package easton.bigbeacons;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import easton.bigbeacons.BeaconHandler;
import easton.bigbeacons.BigBeacons;
import easton.bigbeacons.mixin.BeaconAdvancementMixin;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1263;
import net.minecraft.class_1273;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_174;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2580;
import net.minecraft.class_2586;
import net.minecraft.class_2588;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3000;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3908;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_4275;
import org.jetbrains.annotations.Nullable;

public class BeaconEntity
extends class_2586
implements class_3908,
class_3000 {
    public static final class_1291[][] EFFECTS_BY_LEVEL = new class_1291[][]{{class_1294.field_5904, class_1294.field_5917}, {class_1294.field_5907, class_1294.field_5913}, {class_1294.field_5910}, {class_1294.field_5924}, {class_1294.field_5918}, {class_1294.field_5922}, {class_1294.field_5898}, {class_1294.field_5926}, {class_1294.field_5924}};
    private static final Set EFFECTS = Arrays.stream(EFFECTS_BY_LEVEL).flatMap(Arrays::stream).collect(Collectors.toSet());
    private List<BeamSegment> beamSegments = Lists.newArrayList();
    private List<BeamSegment> field_19178 = Lists.newArrayList();
    private int level;
    private int field_19179 = -1;
    @Nullable
    private class_1291 primary;
    @Nullable
    private class_1291 secondary;
    @Nullable
    private class_2561 customName;
    private class_1273 lock = class_1273.field_5817;
    private final class_3913 propertyDelegate = new class_3913(){

        public int method_17390(int index) {
            switch (index) {
                case 0: {
                    return BeaconEntity.this.level;
                }
                case 1: {
                    return class_1291.method_5554((class_1291)BeaconEntity.this.primary);
                }
                case 2: {
                    return class_1291.method_5554((class_1291)BeaconEntity.this.secondary);
                }
                case 3: {
                    return BeaconEntity.this.levelThree ? 1 : 0;
                }
            }
            return 0;
        }

        public void method_17391(int index, int value) {
            switch (index) {
                case 0: {
                    BeaconEntity.this.level = value;
                    break;
                }
                case 1: {
                    if (!((BeaconEntity)BeaconEntity.this).field_11863.field_9236 && !BeaconEntity.this.beamSegments.isEmpty()) {
                        BeaconEntity.this.playSound(class_3417.field_14891);
                    }
                    BeaconEntity.this.primary = BeaconEntity.getPotionEffectById(value);
                    break;
                }
                case 2: {
                    BeaconEntity.this.secondary = BeaconEntity.getPotionEffectById(value);
                    break;
                }
                case 3: {
                    BeaconEntity.this.levelThree = value == 1;
                }
            }
        }

        public int method_17389() {
            return 4;
        }
    };
    private boolean levelThree;

    public BeaconEntity() {
        super(BigBeacons.BEACON_ENTITY);
    }

    public void method_16896() {
        int n;
        class_2338 blockPos2;
        int i = this.field_11867.method_10263();
        int j = this.field_11867.method_10264();
        int k = this.field_11867.method_10260();
        if (this.field_19179 < j) {
            blockPos2 = this.field_11867;
            this.field_19178 = Lists.newArrayList();
            this.field_19179 = blockPos2.method_10264() - 1;
        } else {
            blockPos2 = new class_2338(i, this.field_19179 + 1, k);
        }
        BeamSegment beamSegment = this.field_19178.isEmpty() ? null : this.field_19178.get(this.field_19178.size() - 1);
        int l = this.field_11863.method_8624(class_2902.class_2903.field_13202, i, k);
        for (n = 0; n < 10 && blockPos2.method_10264() <= l; ++n) {
            class_2680 blockState = this.field_11863.method_8320(blockPos2);
            class_2248 block = blockState.method_26204();
            if (block instanceof class_4275) {
                float[] fs = ((class_4275)block).method_10622().method_7787();
                if (this.field_19178.size() <= 1) {
                    beamSegment = new BeamSegment(fs);
                    this.field_19178.add(beamSegment);
                } else if (beamSegment != null) {
                    if (Arrays.equals(fs, beamSegment.color)) {
                        beamSegment.increaseHeight();
                    } else {
                        beamSegment = new BeamSegment(new float[]{(beamSegment.color[0] + fs[0]) / 2.0f, (beamSegment.color[1] + fs[1]) / 2.0f, (beamSegment.color[2] + fs[2]) / 2.0f});
                        this.field_19178.add(beamSegment);
                    }
                }
            } else {
                if (beamSegment == null || blockState.method_26193((class_1922)this.field_11863, blockPos2) >= 15 && block != class_2246.field_9987) {
                    this.field_19178.clear();
                    this.field_19179 = l;
                    break;
                }
                beamSegment.increaseHeight();
            }
            blockPos2 = blockPos2.method_10084();
            ++this.field_19179;
        }
        n = this.level;
        if (this.field_11863.method_8510() % 80L == 0L) {
            if (!this.beamSegments.isEmpty()) {
                this.updateLevel(i, j, k);
            }
            if (this.level > 0 && !this.beamSegments.isEmpty()) {
                this.applyPlayerEffects();
                this.playSound(class_3417.field_15045);
            }
        }
        if (this.field_19179 >= l) {
            this.field_19179 = -1;
            boolean bl = n > 0;
            this.beamSegments = this.field_19178;
            if (!this.field_11863.field_9236) {
                boolean bl2;
                boolean bl3 = bl2 = this.level > 0;
                if (!bl && bl2) {
                    this.playSound(class_3417.field_14703);
                    Iterator var14 = this.field_11863.method_18467(class_3222.class, new class_238((double)i, (double)j, (double)k, (double)i, (double)(j - 4), (double)k).method_1009(10.0, 5.0, 10.0)).iterator();
                    class_2580 dummyBeacon = new class_2580();
                    ((BeaconAdvancementMixin)dummyBeacon).setLevel(this.getLevel());
                    while (var14.hasNext()) {
                        class_3222 serverPlayerEntity = (class_3222)var14.next();
                        class_174.field_1189.method_8812(serverPlayerEntity, dummyBeacon);
                    }
                } else if (bl && !bl2) {
                    this.playSound(class_3417.field_19344);
                }
            }
        }
    }

    private void updateLevel(int x, int y, int z) {
        int j;
        this.level = 0;
        int i = 1;
        while (i <= 10 && (j = y - i) >= 0) {
            boolean bl = true;
            block1: for (int k = x - i; k <= x + i && bl; ++k) {
                for (int l = z - i; l <= z + i; ++l) {
                    if (this.field_11863.method_8320(new class_2338(k, j, l)).method_26164((class_3494)class_3481.field_22275)) continue;
                    bl = false;
                    continue block1;
                }
            }
            if (!bl) break;
            this.level = i++;
        }
        if (this.level < 4) {
            this.secondary = null;
        }
        if (this.level < 10) {
            this.levelThree = false;
        }
        boolean effectAllowed = false;
        block3: for (int o = 0; o < this.level - 1; ++o) {
            int p = EFFECTS_BY_LEVEL[o].length;
            for (int q = 0; q < p; ++q) {
                if (EFFECTS_BY_LEVEL[o][q] != this.primary) continue;
                effectAllowed = true;
                continue block3;
            }
        }
        if (!effectAllowed) {
            this.primary = null;
            this.secondary = null;
            this.levelThree = false;
        }
    }

    public void method_11012() {
        this.playSound(class_3417.field_19344);
        super.method_11012();
    }

    private void applyPlayerEffects() {
        if (!this.field_11863.field_9236 && this.primary != null) {
            double d = this.level * 10 + 10;
            int i = 0;
            if (this.level >= 4 && this.primary == this.secondary) {
                i = 1;
            }
            if (this.levelThree) {
                i = 2;
            }
            int j = (9 + this.level * 2) * 20;
            class_238 box = new class_238(this.field_11867).method_1014(d).method_1012(0.0, (double)this.field_11863.method_8322(), 0.0);
            List list = this.field_11863.method_18467(class_1657.class, box);
            for (class_1657 playerEntity2 : list) {
                playerEntity2.method_6092(new class_1293(this.primary, j, i, true, true));
            }
            if (this.level >= 4 && this.primary != this.secondary && this.secondary != null) {
                for (class_1657 playerEntity2 : list) {
                    playerEntity2.method_6092(new class_1293(this.secondary, j, 0, true, true));
                }
            }
        }
    }

    public void playSound(class_3414 soundEvent) {
        this.field_11863.method_8396((class_1657)null, this.field_11867, soundEvent, class_3419.field_15245, 1.0f, 1.0f);
    }

    @Environment(value=EnvType.CLIENT)
    public List<BeamSegment> getBeamSegments() {
        return this.level == 0 ? ImmutableList.of() : this.beamSegments;
    }

    public int getLevel() {
        return this.level;
    }

    @Nullable
    public class_2622 method_16886() {
        return new class_2622(this.field_11867, 3, this.method_16887());
    }

    public class_2487 method_16887() {
        return this.method_11007(new class_2487());
    }

    @Environment(value=EnvType.CLIENT)
    public double method_11006() {
        return 256.0;
    }

    @Nullable
    private static class_1291 getPotionEffectById(int id) {
        class_1291 statusEffect = class_1291.method_5569((int)id);
        return EFFECTS.contains(statusEffect) ? statusEffect : null;
    }

    public void method_11014(class_2680 state, class_2487 tag) {
        super.method_11014(state, tag);
        this.primary = BeaconEntity.getPotionEffectById(tag.method_10550("Primary"));
        this.secondary = BeaconEntity.getPotionEffectById(tag.method_10550("Secondary"));
        this.levelThree = tag.method_10577("LevelThree");
        if (tag.method_10573("CustomName", 8)) {
            this.customName = class_2561.class_2562.method_10877((String)tag.method_10558("CustomName"));
        }
        this.lock = class_1273.method_5473((class_2487)tag);
    }

    public class_2487 method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("Primary", class_1291.method_5554((class_1291)this.primary));
        tag.method_10569("Secondary", class_1291.method_5554((class_1291)this.secondary));
        tag.method_10569("Levels", this.level);
        tag.method_10556("LevelThree", this.levelThree);
        if (this.customName != null) {
            tag.method_10582("CustomName", class_2561.class_2562.method_10867((class_2561)this.customName));
        }
        this.lock.method_5474(tag);
        return tag;
    }

    public void setCustomName(@Nullable class_2561 text) {
        this.customName = text;
    }

    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
        return new BeaconHandler(syncId, (class_1263)playerInventory, this.propertyDelegate, class_3914.method_17392((class_1937)this.field_11863, (class_2338)this.method_11016()));
    }

    public class_2561 method_5476() {
        return this.customName != null ? this.customName : new class_2588("container.beacon");
    }

    public static class BeamSegment {
        private final float[] color;
        private int height;

        public BeamSegment(float[] color) {
            this.color = color;
            this.height = 1;
        }

        protected void increaseHeight() {
            ++this.height;
        }

        @Environment(value=EnvType.CLIENT)
        public float[] getColor() {
            return this.color;
        }

        @Environment(value=EnvType.CLIENT)
        public int getHeight() {
            return this.height;
        }
    }
}

