/*
 * Decompiled with CFR 0.152.
 */
package vini2003.xyz.blackhole.common.components;

import dev.onyxstudios.cca.api.v3.component.Component;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import vini2003.xyz.blackhole.common.components.BlackHoleWorldComponent;
import vini2003.xyz.blackhole.common.config.BlackHoleConfig;
import vini2003.xyz.blackhole.common.utilities.BlackHoleUtilities;
import vini2003.xyz.blackhole.registry.common.BlackHoleComponents;

public class BlackHoleComponent
implements Component {
    private class_243 pos = new class_243(0.0, 64.0, 0.0);
    private float size = 1.0f;
    private int countdown = 100;
    private int id;
    private class_1937 world;
    private class_1657 target;
    private final List<BlackHoleParticle> particles = new ArrayList<BlackHoleParticle>();

    public BlackHoleComponent(class_1937 world) {
        this.world = world;
        this.id = ((BlackHoleWorldComponent)BlackHoleComponents.BLACK_HOLES.get((Object)world)).nextId();
    }

    public void tickSize() {
        if (BlackHoleConfig.cache.grow) {
            this.size = Math.min((float)BlackHoleConfig.cache.limit, this.size * (1.0f + BlackHoleConfig.cache.growSpeed));
        }
    }

    public void tickDestruction() {
        if (BlackHoleConfig.cache.damage) {
            BlackHoleUtilities.destroy(this, this.world, (int)this.pos.method_10216(), (int)this.pos.method_10214(), (int)this.pos.method_10215(), (int)this.getSize());
        }
    }

    public void tickPlayerPull() {
        for (class_1297 entity : this.world.method_18456()) {
            if (entity.method_7325() || ((class_1657)entity).method_7337()) continue;
            double distance = this.getPos().method_1022(entity.method_19538());
            if (!BlackHoleConfig.cache.pull) continue;
            if (this.world.field_9236) {
                class_243 pull = this.getPos().method_1020(entity.method_19538()).method_1029();
                pull = pull.method_1021(Math.pow(BlackHoleConfig.cache.pullSpeed, distance * 1.5 / (double)(this.size * 2.5f)));
                if (distance > (double)this.size && entity.method_18798().method_1027() < 3.0) {
                    entity.method_5762(class_3532.method_15350((double)pull.method_10216(), (double)-1.0, (double)1.0), class_3532.method_15350((double)pull.method_10214(), (double)-1.0, (double)1.0), class_3532.method_15350((double)pull.method_10215(), (double)-1.0, (double)1.0));
                    entity.field_6037 = true;
                    entity.field_6007 = true;
                }
                if (!(distance < (double)this.size)) continue;
                entity.method_18799(class_243.field_1353);
                continue;
            }
            if (this.countdown > 0 || !(distance < (double)this.size)) continue;
            entity.method_5768();
        }
    }

    public void tickEntityPull() {
        if (!this.world.field_9236) {
            for (class_1297 entity : ((class_3218)this.world).method_27909()) {
                double distance = this.getPos().method_1022(entity.method_19538());
                if (!BlackHoleConfig.cache.pull || entity instanceof class_1657) continue;
                class_243 pull = this.getPos().method_1020(entity.method_19538()).method_1029();
                pull = pull.method_1021(Math.pow(BlackHoleConfig.cache.pullSpeed, distance * 1.5 / (double)(this.size * 2.5f)));
                if (distance > (double)this.size && entity.method_18798().method_1027() < 3.0) {
                    entity.method_5762(class_3532.method_15350((double)pull.method_10216(), (double)-1.0, (double)1.0), class_3532.method_15350((double)pull.method_10214(), (double)-1.0, (double)1.0), class_3532.method_15350((double)pull.method_10215(), (double)-1.0, (double)1.0));
                    entity.field_6037 = true;
                    entity.field_6007 = true;
                }
                if (this.countdown > 0 || !(distance < (double)this.size)) continue;
                entity.method_5768();
                entity.method_18799(class_243.field_1353);
            }
        }
    }

    public void tickTarget() {
        if (BlackHoleConfig.cache.follow) {
            if (this.target == null || !this.target.method_5805() || this.target.method_7325() || this.target.method_7337()) {
                this.target = this.world.method_18456().stream().filter(player -> !player.method_7325() && !player.method_7337() && player.method_5707(this.getPos()) < 1048576.0).findFirst().orElse(null);
            } else {
                class_243 subtract = this.target.method_19538().method_1020(this.getPos());
                class_243 follow = subtract.method_1029().method_1021((double)BlackHoleConfig.cache.followSpeed);
                this.setPos(this.getPos().method_1019(follow));
            }
        }
    }

    public void tickCountdown() {
        if (this.countdown > 0) {
            --this.countdown;
        }
    }

    public void tick() {
        if (this.countdown <= 0) {
            if (!this.world.field_9236) {
                this.tickSize();
            }
            this.tickDestruction();
            this.tickPlayerPull();
            if (!this.world.field_9236) {
                this.tickEntityPull();
            }
            if (!this.world.field_9236) {
                this.tickTarget();
            }
        } else if (!this.world.field_9236) {
            this.tickCountdown();
        }
    }

    public class_243 getPos() {
        return this.pos;
    }

    public void setPos(class_243 pos) {
        this.pos = pos;
    }

    public float getSize() {
        return this.size;
    }

    public void setSize(float size) {
        this.size = size;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) {
        this.id = id;
    }

    public class_1937 getWorld() {
        return this.world;
    }

    public void setWorld(class_1937 world) {
        this.world = world;
    }

    public List<BlackHoleParticle> getParticles() {
        return this.particles;
    }

    public void readFromNbt(class_2487 compoundTag) {
        this.pos = new class_243(compoundTag.method_10574("X"), compoundTag.method_10574("Y"), compoundTag.method_10574("Z"));
        this.size = compoundTag.method_10583("Size");
        this.countdown = compoundTag.method_10550("Countdown");
        this.id = compoundTag.method_10550("Id");
    }

    public void writeToNbt(class_2487 compoundTag) {
        compoundTag.method_10549("X", this.pos.method_10216());
        compoundTag.method_10549("Y", this.pos.method_10214());
        compoundTag.method_10549("Z", this.pos.method_10215());
        compoundTag.method_10548("Size", this.size);
        compoundTag.method_10569("Countdown", this.countdown);
        compoundTag.method_10569("Id", this.id);
    }

    public static class BlackHoleParticle {
        private class_243 pos;
        private final class_2680 state;
        private final class_1799 stack;

        public BlackHoleParticle(class_243 pos, class_2680 state) {
            this.pos = pos;
            this.state = state;
            this.stack = new class_1799((class_1935)state.method_26204().method_8389());
        }

        public class_243 getPos() {
            return this.pos;
        }

        public void setPos(class_243 pos) {
            this.pos = pos;
        }

        public class_2680 getState() {
            return this.state;
        }

        public class_1799 getStack() {
            return this.stack;
        }
    }
}

