/*
 * Decompiled with CFR 0.152.
 */
package vini2003.xyz.blackhole.common.components;

import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import vini2003.xyz.blackhole.common.components.BlackHoleComponent;
import vini2003.xyz.blackhole.registry.common.BlackHoleComponents;

public class BlackHoleWorldComponent
implements AutoSyncedComponent {
    private final List<BlackHoleComponent> blackHoles = new ArrayList<BlackHoleComponent>();
    private final class_1937 world;
    private int lastId = 0;

    public BlackHoleWorldComponent(class_1937 world) {
        this.world = world;
    }

    public void tick() {
        this.blackHoles.forEach(BlackHoleComponent::tick);
        BlackHoleComponents.BLACK_HOLES.sync((Object)this.world);
    }

    public void readFromNbt(class_2487 compoundTag) {
        class_2499 list = compoundTag.method_10554("BlackHoles", 10);
        list.forEach(blackHoleCompoundTag -> {
            int id = ((class_2487)blackHoleCompoundTag).method_10550("Id");
            Optional<BlackHoleComponent> blackHole = this.blackHoles.stream().filter(existingBlackHole -> existingBlackHole.getId() == id).findFirst();
            if (blackHole.isPresent()) {
                blackHole.get().readFromNbt((class_2487)blackHoleCompoundTag);
            } else {
                BlackHoleComponent blackHoleComponent = new BlackHoleComponent(this.world);
                blackHoleComponent.readFromNbt((class_2487)blackHoleCompoundTag);
                this.blackHoles.add(blackHoleComponent);
            }
        });
        this.lastId = compoundTag.method_10550("LastId");
    }

    public void writeToNbt(class_2487 compoundTag) {
        class_2499 list = new class_2499();
        this.blackHoles.forEach(blackHoleComponent -> {
            class_2487 blackHoleCompoundTag = new class_2487();
            blackHoleComponent.writeToNbt(blackHoleCompoundTag);
            list.add((Object)blackHoleCompoundTag);
        });
        compoundTag.method_10566("BlackHoles", (class_2520)list);
        compoundTag.method_10569("LastId", this.lastId);
    }

    public int nextId() {
        int id = this.lastId++;
        return id;
    }

    public List<BlackHoleComponent> getBlackHoles() {
        return this.blackHoles;
    }
}

