/*
 * Decompiled with CFR 0.152.
 */
package net.darkhax.botanypots.fertilizer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParseException;
import com.google.gson.JsonSyntaxException;
import java.math.BigInteger;
import javax.annotation.Nullable;
import net.darkhax.botanypots.fertilizer.FertilizerInfo;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.registries.ForgeRegistryEntry;

public class FertilizerSerializer
extends ForgeRegistryEntry<IRecipeSerializer<?>>
implements IRecipeSerializer<FertilizerInfo> {
    public static final FertilizerSerializer INSTANCE = new FertilizerSerializer();

    public FertilizerInfo read(ResourceLocation id, JsonObject json) {
        int maxTicks;
        Ingredient ingredient = Ingredient.func_199802_a((JsonElement)json.getAsJsonObject("fertilizer"));
        int minTicks = FertilizerSerializer.readIntClamped(json, "minTicks", 0, Integer.MAX_VALUE, null);
        if (minTicks > (maxTicks = FertilizerSerializer.readIntClamped(json, "maxTicks", minTicks, Integer.MAX_VALUE, null)) || maxTicks < minTicks) {
            throw new JsonSyntaxException("minTicks (" + minTicks + ") must be less than or equal to maxTicks (" + maxTicks + ").");
        }
        return new FertilizerInfo(id, ingredient, minTicks, maxTicks);
    }

    public FertilizerInfo read(ResourceLocation id, PacketBuffer buf) {
        Ingredient ingredient = Ingredient.func_199566_b((PacketBuffer)buf);
        int minTicks = buf.readInt();
        int maxTicks = buf.readInt();
        return new FertilizerInfo(id, ingredient, minTicks, maxTicks);
    }

    public void write(PacketBuffer buffer, FertilizerInfo info) {
        info.getIngredient().func_199564_a(buffer);
        buffer.writeInt(info.getMinTicks());
        buffer.writeInt(info.getMaxTicks());
    }

    private static int readIntClamped(JsonObject json, String memberName, int min, int max, @Nullable Integer defaultValue) {
        if (json.has(memberName)) {
            BigInteger bigMin = BigInteger.valueOf(min);
            BigInteger bigMax = BigInteger.valueOf(max);
            BigInteger bigInt = new BigInteger(json.get(memberName).getAsString());
            if (bigInt.compareTo(bigMin) < 0) {
                throw new JsonParseException("Property " + memberName + " is too small. Must be greater than or equal to " + min);
            }
            if (bigInt.compareTo(bigMax) > 0) {
                throw new JsonParseException("Property " + memberName + " is too big. Must be less than or equal to " + max);
            }
            try {
                return bigInt.intValueExact();
            }
            catch (ArithmeticException e) {
                throw new JsonParseException("Expected property " + memberName + " to be an integer but it's value is out of range.", (Throwable)e);
            }
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        throw new JsonParseException("Property " + memberName + " was undefined.");
    }
}

