/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg;

import com.mojang.brigadier.CommandDispatcher;
import corgiaoc.byg.common.entity.villager.BYGVillagerType;
import corgiaoc.byg.common.properties.BYGCreativeTab;
import corgiaoc.byg.common.properties.vanilla.BYGCarvableBlocks;
import corgiaoc.byg.common.properties.vanilla.BYGCompostables;
import corgiaoc.byg.common.properties.vanilla.BYGFlammables;
import corgiaoc.byg.common.properties.vanilla.BYGHoeables;
import corgiaoc.byg.common.properties.vanilla.BYGPaths;
import corgiaoc.byg.common.properties.vanilla.BYGStrippables;
import corgiaoc.byg.common.world.dimension.end.BYGEndBiomeProvider;
import corgiaoc.byg.common.world.dimension.nether.BYGNetherBiomeProvider;
import corgiaoc.byg.common.world.feature.blockplacer.BYGBlockPlacerTypes;
import corgiaoc.byg.config.autoconfig.BYGWorldConfig;
import corgiaoc.byg.config.json.BYGJsonConfigHandler;
import corgiaoc.byg.core.BYGBlocks;
import corgiaoc.byg.core.BYGEntities;
import corgiaoc.byg.core.BYGItems;
import corgiaoc.byg.core.world.BYGBiomes;
import corgiaoc.byg.core.world.BYGDecorators;
import corgiaoc.byg.core.world.BYGFeatures;
import corgiaoc.byg.core.world.BYGStructures;
import corgiaoc.byg.core.world.BYGSurfaceBuilders;
import corgiaoc.byg.server.command.GenDataCommand;
import java.io.File;
import java.nio.file.Path;
import me.sargunvohra.mcmods.autoconfig1u.AutoConfig;
import me.sargunvohra.mcmods.autoconfig1u.serializer.JanksonConfigSerializer;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v1.CommandRegistrationCallback;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_3124;
import net.minecraft.class_3481;
import net.minecraft.class_3494;
import net.minecraft.class_3798;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class BYG
implements ModInitializer {
    public static final String MOD_ID = "byg";
    public static boolean isClient = false;
    public static Logger LOGGER = LogManager.getLogger();
    public static boolean isUsingMixin;
    public static String FILE_PATH;
    public static final Path CONFIG_PATH;
    public static class_2378<class_1959> EARLY_BIOME_REGISTRY_ACCESS;
    public static BYGWorldConfig DIMENSIONS_CONFIG;

    public void onInitialize() {
        File dir = new File(CONFIG_PATH.toString());
        if (!dir.exists()) {
            dir.mkdir();
        }
        AutoConfig.register(BYGWorldConfig.class, JanksonConfigSerializer::new);
        DIMENSIONS_CONFIG = (BYGWorldConfig)AutoConfig.getConfigHolder(BYGWorldConfig.class).getConfig();
        BYGRegistries.registerBlocks();
        BYGRegistries.registerItems();
        BYGRegistries.registerEntities();
        BYGWorldGenRegistries.registerBiomes();
        BYGWorldGenRegistries.registerDecorators();
        BYGWorldGenRegistries.registerFeatures();
        BYGWorldGenRegistries.registerSurfaceBuilders();
        BYGWorldGenRegistries.registerBlockPlacerType();
        this.commonSetup();
        this.loadComplete();
        this.registerCommand();
    }

    private static void cleanMemory() {
        LOGGER.debug("Cleaning memory...");
        BYGBlocks.flowerPotBlocks = null;
        FILE_PATH = null;
        LOGGER.debug("Cleaned memory!");
    }

    private void commonSetup() {
        LOGGER.debug("BYG: \"Common Setup\" Event Starting...");
        BYGCreativeTab.init();
        BYGJsonConfigHandler.handleOverWorldConfig(CONFIG_PATH);
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960(MOD_ID, "byg_nether"), BYGNetherBiomeProvider.BYGNETHERCODEC);
        class_2378.method_10230((class_2378)class_2378.field_25096, (class_2960)new class_2960(MOD_ID, "byg_end"), BYGEndBiomeProvider.BYGENDCODEC);
        BYGVillagerType.setVillagerForBYGBiomes();
        BYGBiomes.addBiomeEntries();
        LOGGER.info("BYG: \"Common Setup\" Event Complete!");
    }

    private void loadComplete() {
        LOGGER.debug("BYG: \"Load Complete Event\" Starting...");
        BYGCompostables.compostablesBYG();
        BYGHoeables.hoeablesBYG();
        BYGFlammables.flammablesBYG();
        BYGStrippables.strippableLogsBYG();
        BYGCarvableBlocks.addCarverBlocks();
        BYGPaths.addBYGPaths();
        LOGGER.info("BYG: \"Load Complete\" Event Complete!");
    }

    public void registerCommand() {
        CommandRegistrationCallback.EVENT.register((dispatcher, dedicated) -> {
            LOGGER.debug("BYG: \"Server Starting\" Event Starting...");
            GenDataCommand.dataGenCommand((CommandDispatcher<class_2168>)dispatcher);
            LOGGER.info("BYG: \"Server Starting\" Event Complete!");
        });
    }

    static {
        FILE_PATH = "yeet";
        CONFIG_PATH = new File(String.valueOf(FabricLoader.getInstance().getConfigDirectory().toPath().resolve(MOD_ID))).toPath();
        EARLY_BIOME_REGISTRY_ACCESS = null;
    }

    public static class BYGWorldGenRegistries {
        public static void registerBiomes() {
            LOGGER.debug("BYG: Registering biomes...");
            BYGBiomes.init();
            LOGGER.info("BYG: Biomes registered!");
        }

        public static void registerDecorators() {
            LOGGER.debug("BYG: Registering decorators...");
            BYGDecorators.init();
            LOGGER.info("BYG: Decorators registered!");
        }

        public static void registerStructures() {
            LOGGER.debug("BYG: Registering structures...");
            BYGStructures.init();
            LOGGER.info("BYG: Structures registered!");
        }

        public static void registerFeatures() {
            LOGGER.debug("BYG: Registering features...");
            class_3124.class_5436.field_25846 = new class_3798((class_3494)class_3481.field_25807);
            BYGFeatures.init();
            LOGGER.info("BYG: Features registered!");
        }

        public static void registerSurfaceBuilders() {
            LOGGER.debug("BYG: Registering surface builders...");
            BYGSurfaceBuilders.init();
            LOGGER.info("BYG: Surface builders Registered!");
        }

        public static void registerBlockPlacerType() {
            LOGGER.debug("BYG: Registering block placer types...");
            BYGBlockPlacerTypes.init();
            LOGGER.info("BYG: Registering block placer types!");
        }
    }

    public static class BYGRegistries {
        public static void registerBlocks() {
            LOGGER.debug("BYG: Registering blocks...");
            BYGBlocks.init();
            LOGGER.info("BYG: Blocks registered!");
        }

        public static void registerItems() {
            LOGGER.debug("BYG: Registering items...");
            BYGItems.init();
            LOGGER.info("BYG: Items registered!");
        }

        public static void registerEntities() {
            LOGGER.debug("BYG: Registering entities...");
            BYGEntities.init();
            LOGGER.info("BYG: Entities registered!");
        }
    }
}

