/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.end;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.end.EndLayerProviders;
import corgiaoc.byg.config.json.BYGJsonConfigHandler;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_1972;
import net.minecraft.class_2169;
import net.minecraft.class_2378;
import net.minecraft.class_2919;
import net.minecraft.class_2960;
import net.minecraft.class_3541;
import net.minecraft.class_4131;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class BYGEndBiomeProvider
extends class_1966 {
    public static final Codec<BYGEndBiomeProvider> BYGENDCODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGEndBiomeProvider::new)));
    private final long seed;
    private final DatapackLayer mainIslandLayer;
    private final DatapackLayer smallIslandLayer;
    private final class_2378<class_1959> biomeRegistry;
    private final class_3541 generator;
    public static class_4131<class_2960> END_BIOMES = new class_4131();
    public static class_4131<class_2960> VOID_BIOMES = new class_4131();

    public BYGEndBiomeProvider(class_2378<class_1959> registry, long seed) {
        super(BYGEndBiomeProvider.handleJsonAndFillBiomeList(registry));
        this.seed = seed;
        class_2919 sharedseedrandom = new class_2919(seed);
        sharedseedrandom.method_12660(17292);
        this.biomeRegistry = registry;
        this.mainIslandLayer = EndLayerProviders.stackLayers(this.biomeRegistry, seed);
        this.smallIslandLayer = EndLayerProviders.stackVoidLayers(this.biomeRegistry, seed);
        this.generator = new class_3541((Random)sharedseedrandom);
    }

    private static List<class_1959> handleJsonAndFillBiomeList(class_2378<class_1959> registry) {
        BYG.EARLY_BIOME_REGISTRY_ACCESS = registry;
        BYGJsonConfigHandler.handleEndBiomeJsonConfigs(BYG.CONFIG_PATH, registry);
        return Stream.concat(BYGEndBiomeProvider.END_BIOMES.field_18397.stream(), BYGEndBiomeProvider.VOID_BIOMES.field_18397.stream()).map(class_4131.class_4132::method_19035).map(arg_0 -> registry.method_10223(arg_0)).collect(Collectors.toList());
    }

    protected Codec<? extends class_1966> method_28442() {
        return BYGENDCODEC;
    }

    public class_1966 method_27985(long seed) {
        return new BYGEndBiomeProvider(this.biomeRegistry, seed);
    }

    public class_1959 method_16359(int x, int y, int z) {
        int xBitOffset = x >> 2;
        int zBitOffset = z >> 2;
        if ((long)xBitOffset * (long)xBitOffset + (long)zBitOffset * (long)zBitOffset <= 4096L) {
            return (class_1959)this.biomeRegistry.method_31140(class_1972.field_9411);
        }
        float sampledNoise = class_2169.method_8757((class_3541)this.generator, (int)(xBitOffset * 2 + 1), (int)(zBitOffset * 2 + 1));
        if (sampledNoise >= -20.0f) {
            return this.mainIslandLayer.sampleEnd(this.biomeRegistry, x, z);
        }
        return this.smallIslandLayer.sampleEndVoid(this.biomeRegistry, x, z);
    }
}

