/*
 * Decompiled with CFR 0.152.
 */
package corgiaoc.byg.common.world.dimension.nether;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import corgiaoc.byg.BYG;
import corgiaoc.byg.common.world.dimension.DatapackLayer;
import corgiaoc.byg.common.world.dimension.nether.BYGNetherLayerProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import net.minecraft.class_1959;
import net.minecraft.class_1966;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5505;

public class BYGNetherBiomeProvider
extends class_1966 {
    public static final Codec<BYGNetherBiomeProvider> BYGNETHERCODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5505.method_31148((class_5321)class_2378.field_25114).forGetter(theEndBiomeSource -> theEndBiomeSource.biomeRegistry), (App)Codec.LONG.fieldOf("seed").stable().forGetter(theEndBiomeSource -> theEndBiomeSource.seed)).apply((Applicative)instance, instance.stable(BYGNetherBiomeProvider::new)));
    private static final List<String> NETHER_BIOME_IDS = Arrays.asList(BYG.DIMENSIONS_CONFIG.NetherDimension.BlackListNether.trim().replace(" ", "").split(","));
    private final DatapackLayer biomeLayer;
    private final long seed;
    private final class_2378<class_1959> biomeRegistry;
    public static List<class_2960> NETHER_BIOMES = new ArrayList<class_2960>();

    public BYGNetherBiomeProvider(class_2378<class_1959> registry, long seed) {
        super(BYGNetherBiomeProvider.createNetherBiomeList(registry).stream().map(arg_0 -> registry.method_10223(arg_0)).collect(Collectors.toList()));
        this.seed = seed;
        this.biomeRegistry = registry;
        NETHER_BIOMES = BYGNetherBiomeProvider.createNetherBiomeList(registry);
        this.biomeLayer = BYGNetherLayerProvider.stackLayers(this.biomeRegistry, seed);
    }

    public static List<class_2960> createNetherBiomeList(class_2378<class_1959> biomeRegistry) {
        ArrayList<class_2960> NETHER_BIOMES = new ArrayList<class_2960>();
        for (Map.Entry biomeEntry : biomeRegistry.method_29722()) {
            if (((class_1959)biomeEntry.getValue()).method_8688() != class_1959.class_1961.field_9366) continue;
            class_2960 locationKey = ((class_5321)biomeEntry.getKey()).method_29177();
            if (BYG.DIMENSIONS_CONFIG.NetherDimension.IsBlackListNether) {
                if (NETHER_BIOMES.contains(locationKey) || NETHER_BIOME_IDS.contains(locationKey.toString())) continue;
                NETHER_BIOMES.add(locationKey);
                continue;
            }
            for (String id : NETHER_BIOME_IDS) {
                if (!id.equals(locationKey.toString())) continue;
                NETHER_BIOMES.add(locationKey);
            }
        }
        NETHER_BIOMES.removeIf(Objects::isNull);
        return NETHER_BIOMES;
    }

    protected Codec<? extends class_1966> method_28442() {
        return BYGNETHERCODEC;
    }

    public class_1966 method_27985(long seed) {
        return new BYGNetherBiomeProvider(this.biomeRegistry, seed);
    }

    public class_1959 method_16359(int x, int y, int z) {
        return this.biomeLayer.sampleNether(this.biomeRegistry, x, z);
    }
}

